import React from 'react';

import { shallow } from 'enzyme';
import TableBody from '@material-ui/core/TableBody';
import TableRow from '@material-ui/core/TableRow';
import TableCell from '@material-ui/core/TableCell';

import PropertyTable from 'dash/PropertyTable';

describe('PropertyTable', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            rows: [
                {key: 'name', value: 'crazy joe davola'},
                {key: 'age', value: '40'},
                {key: 'job', value: 'clown'},
            ],
            ...propOverrides
        };

        const wrapper = shallow(<PropertyTable {...props} />);

        return {
            props,
            wrapper,
        };
    };

    it('renders the correct number of columns and rows', () => {
        const { wrapper, props } = setup();
        expect(wrapper.find(TableBody).find(TableRow)).to.have.lengthOf(props.rows.length);
    });

    it('renders the correct cell values', () => {
        const { wrapper, props } = setup();
        const keys = wrapper.find(TableRow).map(node => node.find(TableCell).at(0).render().text());
        const values = wrapper.find(TableRow).map(node => node.find(TableCell).at(1).render().text());

        expect(keys).to.deep.equal(props.rows.map(x => x.key));
        expect(values).to.deep.equal(props.rows.map(x => x.value));
    });
});
