import React from 'react';

import { shallow } from 'enzyme';

import { RebootRequired } from 'dash/RebootRequired';

describe('RebootRequired', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            classes: {},
            ...propOverrides
        };

        const wrapper = shallow(<RebootRequired {...props} />);

        return {
            props,
            wrapper,
        };
    };

    it('renders null if reboot is not required', () => {
        const system = {
            reboot_required: {}
        };
        const { wrapper } = setup({ system });
        expect(wrapper.type()).to.equal(null);
    });

    it('renders Link if reboot is required', () => {
        const system = {
            reboot_required: {
                reboot: true,
                reasons: []
            }
        };
        const { wrapper } = setup({ system });
        const link = wrapper.find('Link');

        expect(link).to.have.lengthOf(1);
        expect(link.props().to).to.deep.equal({
            pathname: `/sys/configuration/`, hash: 'power'
        });
    });

    it('renders a list of reasons if reboot is required', () => {
        const system = {
            reboot_required: {
                reboot: true,
                reasons: [
                    'plz reboot',
                    'why not?',
                ]
            }
        };
        const { wrapper } = setup({ system });
        const reasons = wrapper.find('.reason');
        const expected_reasons = system.reboot_required.reasons;

        expect(reasons).to.have.lengthOf(expected_reasons.length);
        expect(reasons.map(node => node.text())).to.deep.equal(expected_reasons);
    });
});
