import React from 'react';

import { shallow } from 'enzyme';

import { SystemLockout } from 'dash/SystemLockout';

describe('SystemLockout', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            classes: {},
            ...propOverrides,
        };

        const wrapper = shallow(<SystemLockout {...props} />);

        return {
            props,
            wrapper,
        };
    };

    it('renders null if there are no lockouts', () => {
        const lockouts = {
            error: false,
        };
        const { wrapper } = setup({ lockouts });

        expect(wrapper.type()).to.equal(null);
    });

    it('renders a list of messages if there is a lockout', () => {
        const lockouts = {
            error: true,
            messages: ['bc there is a lock out', 'and another helpful message'],
        };
        const { wrapper } = setup({ lockouts });
        const messages = wrapper.find('.message');

        expect(messages).to.have.lengthOf(lockouts.messages.length);
        expect(messages.map(node => node.text())).to.deep.equal(
            lockouts.messages
        );
    });
});
