import React from 'react';
import {
    Hint,
    RadialChart,
} from 'react-vis';

class ATXPieChart extends React.Component {
    static defaultProps = {
        graph:{},
        series:[], // array of arrays
        dataset:{},
        metric:{},
        format:{},
        width:150,
        height:150,
    }
    state = {
        tooltip: null,
    }
    render() {
        const {series,metric,format,width,height} = this.props;
        const {tooltip} = this.state;
        const key_map = {};
        // TODO: this is treating the series as individual records, which 
        // precludes the use of N series...
        const pie_data = series.map((records,index) => {
            return records.map((record,r_index) => {
                const key = `r${index}-${r_index}`;
                key_map[key] = record;
                return {
                    ...record,
                    data_key: key,
                    angle: record.value,
                };
            });
        });
        if (pie_data.length > 1) {
            console.warn(`Currently only support 1 data-series per pie chart`);
        }
        const legend_items = pie_data[0].map(
            element => ({
                color: element.color,
                title: element.label,
            })
        );


        return <RadialChart
            data={pie_data[0]}
            width={width || 150}
            height={height || 150} 
            showLabels={width > 400}
            colorType='literal'
            onValueMouseOver={(event) => {
                const tooltip_obj = {};
                tooltip_obj[event.label] = (
                    metric.valueLabel && metric.valueLabel(event.value)
                ) || event.value;
                this.setState({'tooltip':tooltip_obj});
            }}
            onSeriesMouseOut={(event) => {
                this.setState({'tooltip':null});
            }}
            padAngle={0.06}
        >
            {tooltip && <Hint align={{horizontal:'auto',vertical:'auto'}} value={tooltip} />}
        </RadialChart>;
    }
}

export default ATXPieChart;