import React from 'react';
import {
    XYPlot,
    FlexibleWidthXYPlot,
    YAxis,
    XAxis,
    HorizontalGridLines,
    MarkSeries,
    LineSeries,
    Hint,
    VerticalGridLines,
    HorizontalBarSeries,
    VerticalBarSeries,
} from 'react-vis';


class ATXScatterPlot extends React.Component {
    static defaultProps = {
        graph:{},
        data:[],
        dataset:{},
        metric:{},
        format:{},
        width:150,
        height:150,
        line:false,
        bar:false,
    }
    state = {
        tooltip: null,
    }
    clearTooltip() {
        this.setState({'tooltip':null});
    }
    render() {
        const {series,metric,format,width=128,height=128} = this.props;
        const {tooltip} = this.state;
        const data_map = {};
        const final_series = series.map((series_data,series_index) => {
            if (series_data === null || series_data === undefined) {
                return null;
            }
            const label_map = {};
            const subset = series_data.map((point,index) => {
                const key = `s${series_index}-r${index}`;
                data_map[key] = point;
                if (point) {
                    return {
                        x: point.coordinate === undefined? index:point.coordinate,
                        y: point.value || 0,
                        data_key: key,
                        name: point.label,
                        label: point.label,
                        index: index,
                        size: width < 400 ? 1:20,
                    };
                }
                return null;
            }).filter(x => ((x !== undefined) && (x!== null)));
            const Component = (this.props.bar||metric.bar)? VerticalBarSeries :(
                this.props.line? LineSeries: MarkSeries
            );
            var extra_props = {};
            if (this.props.line) {
                extra_props = {
                    style: {
                        fill: 'none'
                    },
                    onNearestXY: (event) => {
                        const original = data_map[event.data_key];
                        // Unfortunately, we get N callbacks (1 per series) in the same stream
                        const tooltip = this.state.tooltip || {};
                        tooltip[original.__key__] = original.label;
                        this.setState({'tooltip': tooltip});
                    }
                };
            } else {
                extra_props = {
                    onValueMouseOver:(event) => {
                        const original = data_map[event.data_key];
                        const tooltip = {};
                        tooltip[event.label] = original.value;
                        this.setState({'tooltip':tooltip});
                    }
                };
            }

            return <Component
                key={`series-${series_index}`}
                data={subset}
                sizeRange={[.2,1]}
                onSeriesMouseOut={this.clearTooltip.bind(this)}
                {...extra_props}
            />;
        });
        const y_axis_props = {};
        if (metric.valueLabel) {
            y_axis_props.tickFormat = metric.valueLabel;
        }
        const x_axis_props = {};
        if (metric.timeLable) {
            x_axis_props.tickFormat = metric.timeLable;
        }
        // console.log(`Tooltip: ${JSON.stringify(tooltip)}`);
        if (width < 400) {
            /* Compressed view of the data for display in a grid */
            const marginLeft = Number.isNaN(width) ? 5: (width || 1) / 2;
            return <XYPlot
                width={width}
                height={height}
                onMouseLeave={this.clearTooltip.bind(this)}
                // margin={{ left: 240, right: 30, top: 30, bottom: 160 }}
            >
                <HorizontalGridLines style={{stroke: '#ccc'}} />
                <YAxis style={{fontSize:height/20}} {...y_axis_props} />
                {final_series}
                {tooltip && <Hint style={{
                    fontSize:'6pt',
                    marginTop:-(height || 1),
                    marginLeft: marginLeft
                }} align={{
                    horizontal:'auto',
                    vertical:'auto'
                }} value={tooltip} />}
            </XYPlot>;
        }
        return <XYPlot
            onMouseLeave={this.clearTooltip.bind(this)}
            height={height}
            xType={metric.coordinateType}
            width={window.innerWidth - 100}
            margin={{left: 100}}
        >
            <HorizontalGridLines style={{stroke: '#ccc'}} />
            <VerticalGridLines style={{stroke: '#aac'}} />
            <YAxis style={{left:'3em',fontSize:'9pt'}} {...y_axis_props} />
            <XAxis style={{fontSize:'9pt'}} {...x_axis_props} />
            {final_series}
            {tooltip && <Hint style={{
                fontSize:'9pt',
                marginTop:-(height || 1),
                marginLeft:(width || 1)/2
            }} align={{
                horizontal:'auto',
                vertical:'auto'
            }} value={tooltip} />}
        </XYPlot>;
    }
}

export default ATXScatterPlot;
