import React from 'react';
import PropTypes from 'prop-types';

import { withStyles } from '@material-ui/core/styles';

import MuiCard from 'dash/MuiCard';
import MuiTypography from 'dash/MuiTypography';

const styles = theme => ({
    card: {
        textAlign: 'center'
    },
    chart: {
        backgroundColor: theme.palette.grey[100],
        padding: theme.spacing(2)
    }
});

class ChartCard extends React.Component {
    static defaultProps = {
        description: null
    }

    render() {
        const { classes, chart, title, description } = this.props;

        return (
            <MuiCard className={classes.card} fullWidth={
                <div className={classes.chart}>
                    {chart}
                </div>
            }>
                <MuiTypography title={description}>
                    {title}
                </MuiTypography>
            </MuiCard>
        );
    }
}

ChartCard.propTypes = {
    title: PropTypes.string.isRequired,
    chart: PropTypes.element.isRequired,
    description: PropTypes.string,
};

export default withStyles(styles)(ChartCard);
