import React from 'react';
import ChartCard from './chartcard';
import COLORS from './colors';
import {apply_accessor,parallel_sets} from './accessor';
// import 'react-vis/dist/style.css';
import ATXPieChart from './atxpiechart';
import ATXScatterPlot from './atxscatterplot';


class Graph extends React.Component {
    static defaultProps = {
        data: [],
        series: [], // sequence of sequence of {'coordinate':x,'value':y, ...}
        graph: {},
        format: {},
        metric: {},
    };
    static option_map = {
        'pie': (props) => {
            return <ATXPieChart {...props} />;
        },
        'scatter': (props, tooltip) => {
            return <ATXScatterPlot {...props} />;
        },
        'line': (props,tooltip) => {
            return <ATXScatterPlot {...props} line={true} />;
        },
        'bar': (props,tooltip) => {
            return <ATXScatterPlot {...props} bar={true} />;
        },
    }
    render() {
        const { series, graph, format, metric} = this.props;
        const final_graph = Graph.option_map[format.type](
            {
                ...this.props,
            }
        );
        return (
            <ChartCard
                chart={final_graph}
                title={graph.title || metric.title}
                description={graph.description||metric.description}
            />
        );
    }
}

export default Graph;
export {COLORS, apply_accessor, Graph};
