/* Render a group's dashboard view from a set-of-datasets

datasets = {
    'passport_status': tabular_data,
    'system_status': tabular_data,
}
charts = chartmodel.GRAPHS
tables = {
    'passport_status': <PassportStatus />
}

*/
import React from 'react';
import { withStyles } from '@material-ui/core/styles';
import RenderGraphs from 'dash/charts/rendergraphs';

const styles = theme => ({
});

class GroupDashboard extends React.Component {
    static defaultProps = {
        datasets: {},
        metrics: null,
        graphs: [],
        tables: [],
        preference_key: 'group-dash',
    };
    graphs() {
        /* Convert graph description into renderable data-sets and components */
        return <RenderGraphs
            {...this.props}
            preference_key={`${this.props.preference_key}-graphs`}
        />;
    }
    tables() {
        return this.props.tables.map((Component,index) => {
            return <Component
                key={`table-${index}`}
            />;
        });
    }
    render() {
        const {classes} = this.props;
        const graphs = this.graphs();
        const tables = this.tables();
        return <div className={classes.dashBoard}>
            {graphs}
            <div className={classes.tables}>
                {tables}
            </div>
        </div>;
    }
}

export default withStyles(styles)(GroupDashboard);
