export const groupBy = (items, key) => {
    if (items) {
        return items.reduce(
            (result, item) => ({
                ...result,
                [item[key]]: [...(result[item[key]] || []), item]
            }),
            {}
        );
    } else {
        return {};
    }
};

export const sum = (arr, key) => {
    /* Count number of items in array with item[key] true */
    if (arr) {
        return arr.reduce(
            (num, item) => (item[key] ? num + 1 : num), 
            0
        );
    } else {
        return 0;
    }
}
