import React from 'react';

import { shallow } from 'enzyme';
import sinon from 'sinon';

import MuiCodeBlock from 'MuiCodeBlock';
import MuiLoader from 'MuiLoader';
import { ProcessesLog } from 'dash/debugging/ProcessesLog';

const response = {config: 'some log'};

const getStorage = () => ({
    url: '/some-url',
    get: sinon.stub().resolves(response)
});

describe('ProcessesLog', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            storage: getStorage(),
            ...propOverrides
        };

        const wrapper = shallow(<ProcessesLog {...props} />);

        return {
            props,
            wrapper,
            instance: wrapper.instance()
        };
    };

    it('calls storage.get on mount', () => {
        const { props } = setup();
        expect(props.storage.get).to.have.been.calledWith(`${props.storage.url}/processes`);
    });

    it('updates state.config on mount', async () => {
        const { wrapper } = await setup();
        expect(wrapper.state('config')).to.equal(response.config);
    });

    it('renders a MuiLoader until state.config is present', () => {
        const { wrapper } = setup();
        expect(wrapper.find(MuiLoader)).to.have.lengthOf(1);
    });

    it('renders a MuiCodeBlock if state.config is present', async () => {
        const { wrapper } = await setup();
        expect(wrapper.find(MuiCodeBlock)).to.have.lengthOf(1);
        expect(wrapper.find(MuiCodeBlock).render().text()).to.equal(response.config);
    });
});
