import React from 'react';
import { withStyles } from '@material-ui/core/styles';
import classNames from 'classnames';
import Paper from '@material-ui/core/Paper';
import Popover from '@material-ui/core/Popover';
import Portal from '@material-ui/core/Portal';
import ClickAwayListener from '@material-ui/core/ClickAwayListener';

const styles = (theme) => ({
    'padding': {
        paddingLeft: theme.spacingBaseline / 2,
        paddingRight: theme.spacingBaseline / 2,
    },
});

const DetailPopover = (props) => {
    /* Renders a simple pop-over like thing that is in-page (not in a portal) */
    const {Component,anchor,on_close,...childProps} = props;

    return <Portal container={document.body}>
        <div className='click-away-catcher' onClick={evt => {
            on_close(evt);
            evt.stopPropagation();
            return true;
        }}>
            <ClickAwayListener onClickAway={evt => on_close(evt)}>
                <Popover
                    anchorEl={anchor}
                    open={true}
                    className={classNames.padding}
                    classes={{}}
                >
                    <Component {...childProps} />
                </Popover>
            </ClickAwayListener>
        </div>
    </Portal>;
};

export default withStyles(styles)(DetailPopover);