import React from 'react';
import Popover from '@material-ui/core/Popover';
import Typography from '@material-ui/core/Typography';
import Paper from '@material-ui/core/Paper';
import classNames from 'classnames';
import { withStyles } from '@material-ui/core/styles';

const styles = (theme) => ({
    error: {
        color: theme.palette.error.dark,
    },
    warning: {
        color: theme.palette.error.light,
    },
    info: {
        color: theme.palette.primary.dark,
    },
    card: {
        padding: theme.spacing(1),
    },
    margin: {
        margin: theme.spacing(1),
    },
});

class DrillDown extends React.Component {
    state = {
        'open': false,
        'anchor': null,
    }
    handleClick = (evt) => {
        const current = !this.state.open;
        this.setState({open: current, anchor: evt.currentTarget});
    }
    render() {
        const {label, color, title, classes} = this.props;
        const id = 'drill-down';

        return <React.Fragment>
            <a
                title={title}
                className={classNames('drill-down-trigger',classes[color],'clickable')}
                onClick={this.handleClick}
            >{label}</a>
            <Popover
                anchorEl={this.state.anchor}
                open={this.state.open}
                id={id}
                className={classNames('drill-down-details',classes[color])}
                classes={{}}
                onClose={this.handleClick}
                anchorOrigin={{
                    vertical: 'bottom',
                    horizontal: 'center',
                }}
            >
                <Paper className={classNames(classes.card,classes[color])} classes={{}}>
                    {this.props.children}
                </Paper>
            </Popover>
        </React.Fragment>;
    }
}

export default withStyles(styles)(DrillDown);
