import React from 'react';

import { withStyles } from '@material-ui/core/styles';
import {stores} from 'storeregistry';
import {providing_nearest_form} from 'formprovider';
import {ReactForm} from 'reactform';
import {default_save_button} from 'reactform';
import {with_focus} from 'dash/focusprovider';

import Paper from '@material-ui/core/Paper';
import FirmwareTable from './FirmwareTable';
import FirmwareUpgradeForm from './FirmwareUpgradeForm';
import MuiLoader from 'MuiLoader';
import WithCurrentUser from 'withcurrentuser';

import { requiring_system_store } from 'systemstorage';
const styles = theme => ({
    table: {
        marginBottom: theme.spacing(2)
    }
});

class FirmwarePage extends React.Component {
    state = {};
    onSave = (evt) => {
        const {focus} = this.props;
        focus.navigate('/sys/debugging/upgrade-progress/'); // TODO: get from mapping...
    }
    onChange = (form,field,value) => {
        if (field === 'firmware' || (field && field.name === 'firmware')) {
            this.setState({
                'firmware': value,
            });
        }
    }
    render() {
        const { classes, system, storage, user } = this.props;

        if (!system) {
            return <MuiLoader />;
        }
        const buttons = [
        ];
        buttons.push((self) => default_save_button(self, {
            'name': 'Upgrade',
            'action_message': 'Upgrade',
            'busy_message': 'Upgrading',
            'title': 'Upgrade firmware',
            'disabled': !(this.state.firmware),
            // 'icon': 'hdd-o',
        }));

        return <React.Fragment>
            <div className = {classes.table}>
                <FirmwareTable />
            </div>
            {user && user.has_permission('config.upgrade') && <ReactForm
                form_key='FirmwareForm'
                target={system}
                use_dialog={false}
                onSave={this.onSave}
                onChange={this.onChange}
                buttons={buttons}
            />}
        </React.Fragment >;
    }
}

export default requiring_system_store(
    providing_nearest_form(
        with_focus(
            WithCurrentUser(
                withStyles(styles)(FirmwarePage)
            )
        ),
        'system_forms',
    ),
);
