import React from 'react';

import { shallow } from 'enzyme';
import sinon from 'sinon';

import MuiLoader from 'MuiLoader';
import PropertyTable from 'PropertyTable';
import { FirmwareTable } from 'dash/firmware/FirmwareTable';
import * as storeregistry from 'storeregistry';

describe('FirmwareTable', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            system: {
                sku: {
                    sku_name: 'sku name',
                    release: '1',
                },
                firmware: {
                    commit: 'commit',
                    branch: 'master',
                }
            },
            user: {
                has_permission: () => true,
            },
            ...propOverrides
        };

        const wrapper = shallow(<FirmwareTable {...props} />);

        return {
            props,
            wrapper,
            instance: wrapper.instance()
        };
    };


    it('renders a MuiLoader until props.system is present', () => {
        const { wrapper } = setup({ system: null });
        expect(wrapper.find(MuiLoader)).to.have.lengthOf(1);
    });

    it('renders a PropertyTable with correct props if user does not have scary permissions', () => {
        const { wrapper } = setup({
            user: {
                has_permission: (perm) => perm !== 'config.scary_debugging',
            },
        });
        const tableProps = wrapper.find(PropertyTable).prop('rows');
        expect(tableProps.map(x => x.key)).to.deep.equal(['SKU', 'Current Firmware']);
    });

    it('renders a PropertyTable with correct props if user has scary permissions', () => {
        const { wrapper } = setup({
            user: {
                has_permission: (perm) => true,
            },
        });
        const tableProps = wrapper.find(PropertyTable).prop('rows');
        expect(tableProps.map(x => x.key)).to.deep.equal(['SKU', 'Current Firmware', 'Commit', 'Branch']);
        expect(tableProps.map(x => x.value)).to.deep.equal([
            'sku name',
            '1',
            'commit',
            'master',
        ]);
    });
});
