import React from 'react';

import { shallow } from 'enzyme';
import sinon from 'sinon';

import MuiSnackbar from 'MuiSnackbar';
import FileUploadTrigger from 'reactform/FileUploadTrigger';
import { FirmwareUpgradeForm } from 'dash/firmware/FirmwareUpgradeForm';

describe('FirmwareUpgradeForm', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            classes: {},
            storage: {
                post: sinon.spy()
            },
            ...propOverrides
        };

        const wrapper = shallow(<FirmwareUpgradeForm {...props} />);

        return {
            props,
            wrapper,
            instance: wrapper.instance()
        };
    };

    it('renders a FileUploadTrigger', () => {
        const { wrapper, instance } = setup();
        const fileUploadTrigger = wrapper.find(FileUploadTrigger);

        expect(fileUploadTrigger).to.have.lengthOf(1);
        expect(fileUploadTrigger.prop('onFinished')).to.equal(instance.onFinished);
    });

    it('renders a MuiSnackbar if firmwareUpgradeInitiated', () => {
        const { wrapper } = setup();

        expect(wrapper.find(MuiSnackbar)).to.have.lengthOf(0);
        wrapper.setState({ firmwareUpgradeInitiated: true });
        expect(wrapper.find(MuiSnackbar)).to.have.lengthOf(1);
    });

    describe('FileUploadTrigger.onFinished', () => {
        it('should set state.firmwareUpgradeInitiated to true', () => {
            const { wrapper } = setup();
            const fileUploadTrigger = wrapper.find(FileUploadTrigger);
            const upload_id = '1234';
            fileUploadTrigger.prop('onFinished')({
                state: { upload_id }
            });

            expect(wrapper.state('firmwareUpgradeInitiated')).to.equal(true);
        });

        it('should call storage.post', () => {
            const { wrapper, props } = setup();
            const fileUploadTrigger = wrapper.find(FileUploadTrigger);
            const upload_id = '1234';
            fileUploadTrigger.prop('onFinished')({
                state: { upload_id }
            });

            expect(props.storage.post).to.have.been.calledWith(
                { upload_id },
                '/api/form_bridge/FirmwareForm/'
            );
        });
    });
});
