import React from 'react';
import {Link} from 'react-router-dom';
import {with_focus} from 'dash/focusprovider';
import PropTypes from 'prop-types';
import {withStyles} from '@material-ui/core/styles';
import classNames from 'classnames';
import MuiButton from './MuiButton';

const styles = (theme) => ({
    link: {
        padding: theme.spacing(1),
        textDecoration: 'none',
        '&:hover': {
            boxShadow: theme.shadows[4],
        },
        display: 'flex',
        flexDirection: 'row',
        width: '100%',
    },
});

class BaseFocusLink extends React.Component {
    static defaultProps = {
        'focus_on': null,
        'as_button': false,
        'to': '',
    }
    onClick = (evt) => {
        evt.stopPropagation();
        this.props.focus.set_focus(this.props.focus_on,this.final_url());
        if (this.props.onClick) {
            this.props.onClick(evt);
        }
        this.props.focus.navigate();
        return true;
    }
    final_url = () => {
        return this.props.to || this.props.focus_on.__url__;
    }
    render() {
        const {classes,focus,focus_on,as_button,className,...childProps} = this.props;
        if (as_button) {
            return <MuiButton
                onClick={this.onClick}
                {...childProps}
            >{this.props.children}</MuiButton>;
        } else {
            return <Link
                className={classNames(classes.link,className)}
                onClick={this.onClick}
                {...childProps}
                to={this.final_url()}
            />;
        }
    }
}
BaseFocusLink.propTypes = {
    focus: PropTypes.object.isRequired, // From with_focus...
    focus_on: PropTypes.shape({
        '__type__': PropTypes.string.isRequired,
        'context': PropTypes.object,
    }),
    to: PropTypes.string,
    onClick: PropTypes.func,
};

export default with_focus(withStyles(styles)(BaseFocusLink));