/* Provide "nearest form-set" resolution for low-level components */
import React from 'react';
const FocusContext = React.createContext();
import getDisplayName from 'react-display-name';
import { withRouter } from 'react-router';
import {Redirect} from 'react-router';
import {Signal} from 'signals';
import UpdateOnSignal from 'updateonsignal';

class Focus {
    constructor(props) {
        const {default_focus,default_url,on_navigation} = props;

        this.default_focus = {default_focus,default_url,default:true};
        this.focus = [this.default_focus];
        this.redirect = null;
        this.navigate_callback = on_navigation;
        this.focus_changed = Signal();
    }
    set_focus(focus,url) {
        url = url || `${window.location.pathname}`;
        const record = {focus,url};
        // Filter out duplicate focus settings...
        if (((!url) || (url && this.focus[this.focus.length-1].url == url))) {
            // There's no change to the url...
            const previous = this.focus[this.focus.length-1].focus;
            if (previous && previous.__type__ == focus.__type__) {
                if (
                    (previous && previous.__pk__ && previous.__pk__ == focus.__pk__) ||
                    (previous && previous.id && previous.id == focus.id)
                ) {
                    if (url && url === window.location.pathname) {
                        console.log(`No change to focus, not creating a new focus record`);
                        this.focus[this.focus.length-1].focus = focus;
                        this.focus_changed.send(this.focus[this.focus.length-1],this);
                        return previous;
                    }
                }
            }
        }
        this.focus.push(record);
        if (this.focus.length > 20) {
            this.focus.splice(0,this.focus.length-20);
        }
        console.log(`New focus ${focus.__key__} on ${url} with title ${this.get_title()}`);
        try {
            this.focus_changed.send(record, this);
            this.navigate(url);
        } catch(e) {
            console.error(`Failure sending focus update signal: ${e}`);
        }
        return record;
    }
    get_key() {
        /* Retrieve our target's __key__ IFF it exists */
        const focus = this.get_focus().focus;
        if (focus && focus.__key__) {
            return focus.__key__;
        }
        return null;
    }
    get_title(routes) {
        /* Get title for the given focus */
        const focus = this.get_focus().focus;
        if (!focus) {
            return null;
        }
        if (focus.title) {
            return focus.title;
        }
        if (focus.name) {
            return focus.name;
        }
        return null;
    }
    navigate(url=null) {
        url = url || this.get_focus().url;
        this.navigate_callback(url);
    }
    matches(location) {
        const focus = this.get_focus();
        const current_url = focus.url;
        if (location.pathname == current_url) {
            return focus;
        } else {
            return this.set_focus(null,location.pathname);
        }
    }
    get_focus() {
        /* return the current focus */
        if (this.focus.length) {
            return this.focus[this.focus.length-1];
        } else {
            return this.default_focus;
        }
    }
    pop_focus() {
        /* pop (remove) and return the current focus */
        if (this.focus.length) {
            const result = this.get_focus();
            this.focus.length = this.focus.length-1;
            return result;
        } else {
            return this.default_focus;
        }
    }
    clear_history = () => {
        this.focus = [this.default_focus];
    }
}

function with_focus(Component) {
    /* When decorated, the component receives the prop focus with is the global Focus instance */
    function WithFocus(props) {
        return <FocusContext.Consumer>
            {(focus) => <UpdateOnSignal signals={[focus.focus_changed]} focus={focus} Component={Component} {...props} />}
        </FocusContext.Consumer>;
    }
    return WithFocus;
}

class BaseFocusProvider extends React.Component {
    /* Top level component that provides whole-app focus object */
    static defaultProps = {
        match: null,
        location: null,
        history: null,
    }
    state = {
        focus: null,
    }
    on_navigation = (url) => {
        console.log(`Redirect to ${url}`);
        if (url != this.props.location.pathname) {
            this.props.history.push(url);
        } else {
            console.debug(`Requested redirect to current location ${url}`);
        }
    }
    componentDidMount() {
        const focus = new Focus({
            default_focus:this.props.default_focus,
            default_url: this.props.default_url,
            on_navigation: this.on_navigation,
        });
        // console.warn(`Creating a focus provider`);
        this.setState({'focus':focus});
    }
    render() {
        /* Ugh, obviously a code smell, and we need to fix that */
        if (! this.state.focus) {
            return null;
        }
        return <FocusContext.Provider value={this.state.focus}>
            {this.props.children}
        </FocusContext.Provider>;
    }
}
const FocusProvider = withRouter(BaseFocusProvider);

export {FocusContext, FocusProvider, with_focus, Focus};
