/* Renderer for a set of issues that are to be reported to the user */
import React from 'react';
import AlignDiv from 'reactform/aligndiv';
import List from '@material-ui/core/List';
import ListItem from '@material-ui/core/ListItem';
import Link from 'react-router-dom';
import {EditIntent} from 'editintent';
import EditingCard from 'dash/editingcard';
import theme from 'dash/theme';

class IssueList extends React.Component {
    static defaultProps = {
        'problems': [],
    }
    render() {
        const {problems,alignment} = this.props;
        const items = [];
        problems.map((problem,i) => {
            const sub_items = [];
            if (problem.objects && problem.objects.length) {
                problem.objects.map((obj,j) => {
                    if (!obj) {return;}
                    if (obj.url) {
                        sub_items.push(<Link to={obj.url}>{`${obj.title}`}</Link>);
                    } else {
                        sub_items.push(<EditIntent form_key={obj.form_key} target={obj} key={`obj-${j}`} label='' title={obj.title} as_link={true} /> );
                    }
                });
            }
            items.push(<ListItem key={`problem-${i}`}>
                {problem.messages}{' '}
                {sub_items}
            </ListItem>);
        });
        return <React.Fragment>
            <List key='details' onClick={this.toggle_state}>{items}</List>
        </React.Fragment>;
    }
}

const ProblemCard = (props) => {
    const {instance} = props;
    if (instance.problems && instance.problems.length) {
        return <EditingCard icon={theme.icons.bug} icon_props={{color: 'error'}} title={`${instance.__type__} ${instance.title} Issues`} no_wrapper={true}>
            <IssueList key='problems' problems={instance.problems} />
        </EditingCard>;
    } else {
        return null;
    }
};

export default IssueList;
export {ProblemCard, IssueList};