import React from 'react';
import { shallow } from 'enzyme';

import ListItem from '@material-ui/core/ListItem';

import ExternalLicenses from 'dash/licenses/ExternalLicenses';

describe('ExternalLicenses', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            match: {
                path: 'some-path'
            },
            config: {
                licenses: {
                    pkg_infos: [{ Name: 'package 1' }, { Name: 'package 2' }, { Name: 'package 3' }]
                }
            },
            ...propOverrides
        };

        const wrapper = shallow(<ExternalLicenses {...props} />);

        return {
            props,
            wrapper
        };
    };

    it('renders the correct title', () => {
        const { wrapper } = setup();
        expect(wrapper.find('SectionTitle').props().title).to.equal('External Package Licenses');
    });

    it('renders the correct number of packages', () => {
        const { wrapper } = setup();
        expect(wrapper.find(ListItem)).to.have.lengthOf(3);
    });
});
