import React from 'react';
import { shallow } from 'enzyme';

import ListItem from '@material-ui/core/ListItem';

import PackageLicenses from 'dash/licenses/PackageLicenses';

describe('PackageLicenses', () => {
    const setup = (propOverrides = {}) => {
        const props = {
            match: {
                path: 'some-path'
            },
            config: {
                licenses: {
                    os: 'centOS',
                    packages: [['package 1', null], ['package 2', null], ['package 3', null]]
                }
            },
            ...propOverrides
        };

        const wrapper = shallow(<PackageLicenses {...props} />);

        return {
            props,
            wrapper
        };
    };

    it('renders the correct title', () => {
        const { wrapper } = setup();
        expect(wrapper.find('SectionTitle').props().title).to.equal('centOS Package Licenses');
    });

    it('renders the correct number of packages', () => {
        const { wrapper } = setup();
        expect(wrapper.find(ListItem)).to.have.lengthOf(3);
    });
});
