import { matchPath } from "react-router";

const getActiveRoutes = (routes, pathname) => {
    /* Return the array of routes which match pathname (ancestors of the path) */
    for (var index=0;index<routes.length; index++) {
        const route = routes[index];
        if (route.routes) {
            const child_match = getActiveRoutes(route.routes, pathname);
            if (child_match) {
                return [route,...child_match];
            }
        }
        if (matchPath(pathname, route)) {
            return [route];
        }
    }
    return null;
};

const getActiveSection = (routes, pathname) => {
    const active = getActiveRoutes(routes, pathname);
    if (active && active.length) {
        return active[0];
    }
    return null;
};

const getActiveRoute = (routes, match_path) => {
    /* Search for the route with the longest match in the set of matches */
    for (var i = 0;i<routes.length; i++) {
        const route = routes[i];
        if (matchPath(match_path,route)) {
            if (route.routes) {
                return getActiveRoute(route.routes,match_path) || route;
            }
            return route;
        } else {
            if (route.routes) {
                const match = getActiveRoute(route.routes,match_path);
                if (match) {
                    return match;
                }
            }
        }
    }
    return null;
};

export { getActiveSection, getActiveRoute, getActiveRoutes };
