/* Get the context for the view if we don't already have it */
import React from 'react';
import {with_focus} from 'dash/focusprovider';
import {using_nearest_form} from 'formprovider';
import MuiLoader from 'dash/MuiLoader';
import {ErrorList} from 'errorlist';
import {POST_SIGNAL} from "storages/ajaxobservables";

class BaseResolveFocus extends React.Component {
    static defaultProps = {
        '__type__': null,
        '__pk__': null,
        'focus_props': null,
    }
    active=true
    state = {
        'loaded': false,
        'error': false,
        'messages': [],
    }
    mark_loaded = () => {
        if (this.active) {
            this.setState({
                'loaded': true, 'error': false, 'messages': [] 
            });
        }
    }
    final_focus = () => {
        const { focus_props, __type__, __pk__ } = this.props;
        if (focus_props) {
            return focus_props;
        } else {
            return {
                __type__: __type__,
                id: __pk__, // can't do a query for __ prefixed name through web...
            };
        }
    }
    refresh = () => {
        const { focus } = this.props;
        const focus_props = this.final_focus();
        const expected_key = `${focus_props.__type__}.${focus_props.id}`;

        this.props.storage.get_form(focus_props.__type__, focus_props.id, focus_props.context).then(
            (result) => {
                if (result && result.success) {
                    if (result.instance) {
                        if (focus_props.id != '__default__' && focus_props.id !== null && result.instance.__key__ != expected_key) {
                            console.info(
                                `Loaded instance does not have __key__ ${expected_key}, has ${JSON.stringify(result)}`
                            );
                        }
                        focus.set_focus(result.instance);
                        this.mark_loaded();
                    } else {
                        throw (`Null instance on get_form request`);
                    }
                } else {
                    throw( result || '' );
                }
            }
        ).catch((e) => {
            console.info(`Reload retry`);
            window.setTimeout(this.reload, 5000);
            if (this.active) {
                this.setState({
                    'loaded': false,
                    'error': true,
                    'messages': e.messages || e.message || [
                        `Error loading: ${e}`
                    ],
                });
            }
        });
    }
    reload = () => {
        if (! this.state.loaded) {
            const { focus } = this.props;
            const focus_props = this.final_focus();
            const expected_key = `${focus_props.__type__}.${focus_props.id||focus_props.__pk__}`;
            const from_context = focus.get_focus().focus;
            this.refresh();
        }
    }
    
    componentDidMount() {
        this.reload();
        POST_SIGNAL.listen(this.refresh);
    }
    componentWillUnmount() {
        this.active = false;
        POST_SIGNAL.ignore(this.refresh);
    }
    render() {
        if (this.state.loaded) {
            return <React.Fragment>{this.props.children}</React.Fragment>;
        } else if (this.state.error) {
            const messages = Array.isArray(this.state.messages)?this.state.messages: [this.state.messages];
            return <ErrorList errors={messages} />;
        } else {
            return <MuiLoader />;
        }
    }
}
const ResolveFocus = with_focus(using_nearest_form(BaseResolveFocus))
const with_resolve_focus = (Component) => {
    return (props) => {
        const {__type__,__pk__,focus_props,...childProps} = props;
        return <ResolveFocus __type__={__type__} __pk__={__pk__} focus_props={focus_props}>
            <Component {...childProps} />
        </ResolveFocus>;
    }
};

export default with_resolve_focus;
