import React from 'react';
import PropTypes from 'prop-types';
import { withStyles } from '@material-ui/core/styles';
import classNames from 'classnames';

const styles = theme => ({
    root: {

    },
    header: {
        backgroundColor: theme.palette.headers.card,
        fontWeight: 'normal',
        paddingTop: Math.round(theme.spacing(1)),
        paddingBottom: Math.round(theme.spacing(1)),
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
    },
    value: {
    },
    simple: {
        textAlign: 'center',
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
        borderBottomColor: theme.palette.lines.separators,
        borderBottomWidth: 'thin',
        borderBottomStyle: 'solid',
    }
});

class StructTable extends React.Component {
    render() {
        const {classes, root, include_null,...childProps} = this.props;
        const rows = [];
        const raw_types = {
            'string': true,
            'number': true,
            'boolean': true,
            'undefined': true,
            'bigint': true,
            'symbol': true,
            'function': true,
        };
        Object.keys(root).map((key,i) => {
            const value = root[key];
            const typ = typeof value;
            if (value === null || raw_types[typ] ) {
                if ((!include_null) && (value === null || value === undefined)) {
                    return;
                }
                rows.push(
                    <tr key={i}>
                        <th className={classes.header}>{key}</th>
                        <td className={classNames(classes.simple,classes.value)}>{value}</td>
                    </tr>
                );
            } else {
                rows.push(
                    <tr key={i}>
                        <th className={classes.header}>{key}</th>
                        <td className={classNames(classes.subtable,classes.value)}>
                            <StructTable classes={classes} root={value} include_null={include_null} {...childProps} />
                        </td>
                    </tr>
                );
            }
        });
        return <table className={classes.root} {...childProps}>
            <tbody>{rows}</tbody>
        </table>;
    }
}

export default withStyles(styles)(StructTable);