import { createMuiTheme } from '@material-ui/core/styles';
import * as colors from '@material-ui/core/colors';

const spacingBaseline = 8;

const theme = createMuiTheme({
    palette: {
        primary: {
            shading: '#00447c50',
            light: '#1695fe',
            main: '#00447c',
            dark: '#03080d',
            very: '#010407',
        },
        secondary: {
            main: '#026f80',
        },
        common: {
            text: colors.grey[900]
        },
        headers: {
            card: '#00447c50',
            table: '#00447c10',
            tableGroup: '#00447c07',
        },
        footers: {
            card: '#00447c50',
            table: '#00447c10',
        },
        lines: {
            separators: '#00447c50',
        },
        errorLevel: {
            critical: colors.red[700],
            error: colors.red[500],
            warning: colors.amber[700],
            info: colors.grey[700],
            debug: colors.grey[300],
        },
        warning: colors.amber[700],
        success: colors.green[700],
        red: colors.red[500],
        green: colors.green[500],
        orange: colors.orange[500],
        purple: colors.purple[500],
        teal: colors.teal[500],
        disabled: colors.grey[300],
    },
    icons: {
        'delete': 'close',
        'disable': 'highlight_off',
        'edit': 'edit',
        'add': 'add',
        'success': 'check_circle',
        'warning': 'warning',
        'error': 'error',
        'info': 'info',
        'bool_true': 'check_box',
        'bool_false': 'check_box_outline_blank',
        'bool_unknown': 'indeterminate_check_box',

        'check_circle': 'check_circle',
        'remove_circle': 'remove_circle',
        'check_box': 'check_box',
        'check_box_outline_blank': 'check_box_outline_blank',
        'indeterminate_check_box': 'indeterminate_check_box',
        'circle': 'radio_button_unchecked',
        'thumb_up': 'thumb_up',
        'thumbs_up': 'thumb_up',
        'remove': 'remove',
        'break_link': 'unlink',
        'check': 'check',
        'close': 'close',
        'phone_link_off': 'phone_link_off',
        'expand_less': 'expand_less',
        'expand_more': 'expand_more',
        'bug': 'bug_report',
        'deploy': 'publish',
        'ping': 'signal',
        'replay': 'replay',
        'poweroff': 'poweroff',
    },
    status: {
        danger: 'orange'
    },
    sidebarWidth: 180,
    spacing: spacingBaseline,
    toolbar: {
        height: '64px'
    },
    typography: {
        fontWeightBold: 900,
    },
    spacingBaseline: spacingBaseline,
});

export default theme;
