import React from 'react';
import { withStyles } from '@material-ui/core/styles';
import MuiButton from './MuiButton';
import MuiTypography from 'dash/MuiTypography';
import LoginButton from 'dash/loginbutton';
import WithCurrentUser from 'withcurrentuser';

const styles = theme => ({
    username: {
        marginRight: theme.spacing(2)
    },
    logout: {
        textTransform: 'none',
        borderLeft: `1px solid ${theme.palette.divider}`
    },
});

class BaseUserName extends React.Component {
    static defaultProps = {
        user: null,
        classes: null,
    }
    render() {
        const {user, classes} = this.props;
        const has_user = user && user.id ? true : false;
        return <React.Fragment>
            {has_user && (
                <MuiTypography
                    className={classes.username}
                    key='username'
                >
                    {user.name}
                </MuiTypography>
            )}
            {has_user && (
                <MuiButton
                    key='logout'
                    className={classes.logout}
                    href="/accounts/logout/"
                >
                    Logout
                </MuiButton>
            )}
            {(!has_user) && <LoginButton key='login' />}
        </React.Fragment>;
    }
}
const UserName = withStyles(styles)(WithCurrentUser(BaseUserName));

export default UserName;
export {UserName, BaseUserName};