import React from 'react';
import Config from 'config';
import getDisplayName from 'react-display-name';
import wraps from 'wraps';

function with_error_boundary(Component) {
    class ErrorBoundary extends React.Component {
        /* HOC that catches errors in a rendered component */
        state = {
            error: null,
            errorInfo: null,
        };
        componentDidCatch(error, info) {
            this.setState({
                error: error,
                errorInfo: info
            });
        }
        render() {
            if (this.state.errorInfo) {
                return <div className="error">
                    <h2 className="error">GUI Error</h2>
                    <p>
                        We encountered an error on this page,
                        as a result we can't continue displaying the
                        view. Please report this to <a href={Config.support_url}>{Config.company_short_name} Support</a> along
                        with the page URL, and any details about what
                        you were trying to do when the error occurred.
                    </p>
                    <details style={{ whiteSpace: 'pre-wrap' }}>
                        {this.state.error && this.state.error.toString()}
                        <br />
                        {this.state.errorInfo.componentStack}
                    </details>
                </div>;
            }
            return <Component {...this.props} />;
        }
    }
    return wraps(ErrorBoundary, Component, 'with_error_boundary');
}

export default with_error_boundary;
