;
(function ( $, window, document, undefined ) {
    /* provide data-attribute filling on DOM nodes from model nodes */
    $.template_lookup = function( model, key ) {
        if (key && key[0] == '!') {
            reverse = true;
            key = key.slice(1,key.length);
        } else {
            reverse = false;
        }
        var chain = key.split('.');
        var current = model;
        var subkey;
        
        for (var i=0;i<chain.length;i++) {
            subkey = chain[i];
            if (subkey ==='') {
                /* use the object itself */
                current = current;
            } else if ((current[subkey] !== undefined) && (current[subkey] !== null)) {
                current = current[subkey];
            } else {
                current = undefined;
                break;
            }
        }
        if (reverse) {
            current = !(current);
        }
        return current;
    };
    var remove_node = function( nodes, node ) {
        return nodes.not(node);
    };
    var sub_template = function( node, trigger ) {
        var template = node.data('template') || node.clone().attr( trigger, null );
        node.data('template',template);
        // don't what the children hidden, normally
        template.removeClass('hidden');
        node.addClass('hidden');
        node.hide();
        
        var children = node.data('rendered-children');
        if (children === undefined) {
            children = [];
            node.data('rendered-children',children);
        }
        return template;
    };
    var remove_rendered = function( to_expand, node ) {
        var children = node.data('rendered-children');
        $.map(children,function(child) {
            to_expand = remove_node(to_expand,child);
        });
        return to_expand;
    };
    var expand_templates = function( nodes, model, formats ) {
        var to_expand = $(nodes);
        nodes.filter('[data-if]').each(function() {
            var node = $(this);
            var value = $.template_lookup( model,node.attr('data-if'));
            if (value === undefined || ! value) {
                node.addClass('hidden');
                /* do not recurse into it */
                to_expand = remove_node(to_expand,node);
            } else {
                node.removeClass('hidden');
            }
        });
        nodes.filter('[data-with]').each(function() {
            var node = $(this);
            to_expand = remove_node(to_expand,node);
            var child;
            var template = sub_template( node, 'data-with' );
            var children = node.data('rendered-children' );
            if (children.length === 0) {
                child = template.clone();
                child.insertAfter(node);
                children.push( child );
            } else {
                child = children[0];
            }
            to_expand = remove_node( to_expand,child );
            var namespace = {};
            $.extend(namespace,model);
            $.map(node.attr('data-with').split(','),function( item ) {
                var varname,source;
                item = item.split(':');
                varname = item[0];
                source = item[1];
                var value = $.template_lookup(model,source) || undefined;
                namespace[varname] = value;
            });
            node.data('data-record',namespace);
            expand_templates( $(children[0]), namespace, formats );
        });
        nodes.filter('[data-for]').each(function() {
            var node = $(this);
            to_expand = remove_node(to_expand,node);
            var varname,item,source;

            item = node.attr('data-for').split(':');
            varname = item[0];
            source = item[1];
            
            var template = sub_template(node,'data-for');
            var children = node.data('rendered-children');
            to_expand = remove_rendered( to_expand, node );
            
            var value = $.template_lookup(model,source) || [];
            $.map( value, function( item,i ) {
                var current = children[i];
                if (current === undefined) {
                    current = template.clone();
                    if (children.length) {
                        current.insertAfter( children[children.length-1] );
                    } else {
                        current.insertAfter( node );
                    }
                    children[i] = current;
                }
                var sub_model = {};
                $.extend(sub_model,model);
                sub_model[varname] = item;
                current.data('data-record',sub_model);
                expand_templates( $(current), sub_model, formats );
            });
            if (children.length > value.length) {
                // remove excess
                $.map(children.slice(value.length,children.length),function(item) {
                    item.remove();
                });
                children.length = value.length;
            }
        });
        nodes.filter('[data-attribute]').each(function() {
            var node = $(this);
            var value = $.template_lookup( model,node.attr('data-attribute'));
            var text;
            var formatter = (formats || {})[ node.attr('data-format') ];
            if (formatter) {
                text = formatter( value, model, node );
            } else {
                if (value !== undefined) {
                    text = '' + value;
                } else {
                    text = '';
                }
            }
            if (node.text() !== text) {
                if (node.text()) {
                    node.fadeOut( 250,function() {
                        node.text(text);
                        node.fadeIn( 250 );
                    });
                } else {
                    node.text(text);
                }
            }
        });
        nodes.filter('[data-class-if]').each(function() {
            var node = $(this);
            $.map(node.attr('data-class-if').split(','),function( set ) {
                set = set.split(':');
                var key,if_true,if_false;
                key =set[0];
                if_true = set[1];
                if_false = set[2];
                var value = $.template_lookup( model,key);
                if (value) {
                    node.addClass( if_true );
                    if (if_false !== undefined) {
                        node.removeClass( if_false );
                    }
                } else {
                    if (if_false !== undefined) {
                        node.addClass( if_false );
                    }
                    node.removeClass(if_true);
                }
            });
        });
        nodes.filter('[data-attribute-map]').each(function() {
            var node = $(this);
            $.map(node.attr('data-attribute-map').split(','),function( pair ) {
                var key,attr;
                pair = pair.split(':');
                key = pair[0];
                attr = pair[1] || key;
                var value = $.template_lookup(model,key);
                if (value !== undefined) {
                    node.attr( attr,value);
                } else {
                    node.attr( attr, null );
                }
            });
        });
        //to_expand = to_expand.not('[data-for]').not('[data-with]');
        $.map( to_expand, function( child ) { 
            expand_templates(
                $(child).children(),
                model,
                formats
            );
        });
    };
    $.fill_template = function( view, model, formats ) {
        expand_templates( $(view),model, formats );
        return view;
    };
})( jQuery, window, document );
