;
(function ( $, window, document, undefined ) {
    var render_error = function( message ) {
        if (!(message instanceof Array)) {
            message = [message];
        }
        
        var node = $('<ul class="error-list error no-bullets"></div>');
        $.map(message,function(msg) {
            node.append($('<li class="error-message"></li>').text(msg));
        });
        return node;
    };
    $.clear_errors = function( form, field ) {
        form.find( '.error-list' ).each( function() {
            $(this).remove();
        });
        form.find( '.error-message' ).each( function() {
            $(this).remove();
        });
        form.find( '.form-field.error' ).each( function() {
            $(this).removeClass( 'error' );
        });
    };
    $.render_errors = function( form, errors,no_clear ) {
        /* renders JSON error messages into form, clearing previous errors
       
        Pass {} as errors to clear errors on success
        */
        if (!no_clear) {
            form.find( '.error-message' ).each( function() {
                $(this).remove();
            });
            form.find( '.form-field.error' ).each( function() {
                $(this).removeClass( 'error' );
            });
        }
        if (! errors) {
            return;
        }
        $.each( errors, function(key,value) {
            var node;
            if (key=='__all__') {
                node = form;
            } else {
                node = form.find( 'input[name='+key+']' );
                if (! node.length) {
                    node = form.find( 'select[name='+key+']' );
                }
                if (! node.length) {
                    node = form.find( 'textarea[name='+key+']' );
                }
                if (! node.length) {
                    node = form;
                } else {
                    parent = node.closest('.field-body' );
                    if (parent.length) {
                        node = parent;
                    } else {
                        
                    }
                    node.closest( '.form-field' ).addClass( 'error' );
                }
            }
            node.prepend( render_error( value ));
        });
    };
})( jQuery, window, document );
