import React from 'react';
import moment from 'moment';
class DateDisplay extends React.Component {
    /* Component used to display a long-form date */
    render() {
        if (this.props.date) {
            var date = new Date( this.props.date * 1000 );
            date = moment(date);
            var title = `Date is displayed in your browser's time: ${date.format('dddd, MMMM Do, YYYY HH:mm:ss ZZ')}`;
            var formatted = date.format('YYYY-MM-DD HH:mm');
            return <span className="date-display" title={title}>{formatted}</span>;
        } else {
            return <span className="date-display empty"></span>;
        }
    }
}
var DateDisplayFactory = React.createFactory( DateDisplay );
export {DateDisplay,DateDisplayFactory};
