/* Provides tabular layout for status tables and the like see also: puregrid */
import React from 'react';
import {ErrorList} from 'errorlist';

class FieldLayout extends React.Component {
    static defaultProps = {
        className: 'form-field',
        bodyClassName: '',
        title: null,
        label: null
    }
    render() {
        var className = 'field-layout '+this.props.className;
        var bodyClassName = 'field-body '+this.props.bodyClassName;
        var label = this.props.label;
        if (typeof label === 'string') {
            label = <label className="field-label">{label}</label>;
        }
        return <div className={className} title={this.props.title}>
            {label}
            <div className={bodyClassName}>
                {this.props.value || this.props.children}
            </div>
        </div>;
    }
}
var FieldLayoutFactory = React.createFactory( FieldLayout );

var DisplayField = function( props, ...children ) {
    props.className = (props.className || '') + ' display-field ';
    if (props.errors) {
        children.push( ErrorList({errors:props.errors}));
    }
    return FieldLayoutFactory( props, ...children );
};

export {FieldLayout,FieldLayoutFactory,DisplayField};
