import React from 'react';

class SignalClient extends React.Component {
    handleSignalUpdate() {
        this.setState({});
    }
    componentWillMount() {
        var self = this;
        self.props.signals().map(function( signal ) {
            signal.listen( self.handleSignalUpdate.bind(self) );
        });
    }
    componentWillUnmount() {
        var self = this;
        self.props.signals().map(function( signal ) {
            signal.ignore( self.handleSignalUpdate.bind(self) );
        });
    }
    render() {
        var self = this;
        if (! this.props.children || (! this.props.children.length)) {
            return null;
        }
        if (this.props.children && this.props.children.length===1) {
            return this.props.children[0];
        }
        console.log("SignalClient/with_signals should only have a single child");
        return <div>{self.props.children}</div>;
    }
}
var with_signals = function( props, ...children ) {
    if (children.length == 0) {
        children = null;
    }
    return <SignalClient {...props}>{ children}</SignalClient>;
};

export {SignalClient,with_signals};
