;
(function ( $, window, document, undefined ) {
    $.logViewer = function( viewer ) {
        var log_view = $(viewer);
        var _poll_timer_handle = null;
        var line_template = $('.templates .log-line');
        var markup = function( raw_log ) {
            log_view.empty();
            var last_log = null;
            $.map( raw_log.split('\n'), function( line ) {
                var lineparser = /[\[]?(DEBUG|INFO|WARN|WARNING|ERROR|CRITICAL)[\]]?\W+([^ ]+)\W+([^ ]+)\W+([^ ]+)\W(.*)/;
                var groups = lineparser.exec( line );
                var message;
                var logline = null;
                if ((! groups) || (groups[0] != line)) {
                    if (last_log) {
                        message = last_log.find('.message');
                        message.text( message.text() + '\n'+line );
                    }
                } else {
                    logline = line_template.clone();
                    last_log = logline;
                    if (groups[1] == 'DEBUG') {
                        return;
                    }
                    logline.addClass( groups[1] );
                    var level = logline.find('.level');
                    logline.append( level );
                    level.text(groups[1]);
                    var date = logline.find( '.date' );
                    logline.append( date );
                    date.text( groups[3] + ' ' + groups[4] );
                    message = logline.find( '.message' );
                    logline.append( message );
                    message.text( groups[5] );
                }
                if (logline) {
                    log_view.append( logline );
                }
            });
        };
        var poll = function() {
            $.ajax({
                url: log_view.attr( 'data-url' ),
                cache: false,
                success: function( data ) {
                    log_view.removeClass( 'error' );
                    markup( data );
                },
                error: function( jqxhr, status, errThrown ) {
                    if (jqxhr.state && jqxhr.state() == 'rejected') {
                        log_view.text('Connection to the server rejected, likely due to a web server restart. If this message persists you may need to reload the window and accept the new web-server SSL certificate');
                    } else {
                        log_view.addClass( 'error' );
                        log_view.text( status+': '+(errThrown||'Unknown'));
                    }
                }
            });
        };
        var start = function() {
            if (! _poll_timer_handle) {
                poll();
                _poll_timer_handle = window.setInterval( poll, 5*1000 );
            }
        };
        var stop = function() {
            if (_poll_timer_handle) {
                window.clearInterval( _poll_timer_handle );
            }
            _poll_timer_handle = null;
        };
        var start_or_stop = function() {
            if ($('.continue-checking').attr( 'checked' )) {
                start();
            } else {
                stop();
            }
        };
        var continue_checking = $( '.continue-checking' );
        if (continue_checking.length) {
            continue_checking.change(start_or_stop );
            start_or_stop();
        } else {
            start();
        }
        continue_checking.togglebox();
        return {
            'poll': poll,
            'start': start,
            'stop': stop,
            'start_or_stop': start_or_stop,
            'log_view': log_view
        };
    };
})( jQuery, window, document );
