;

var media = (function () {
    "use strict";
    var media = {};

    var DAY = 60 * 60 * 24, HOUR = 60 * 60, MINUTE = 60;
    var DAY_SIZES = [['days', DAY], ['hours', HOUR], ['minutes', MINUTE], ['seconds', 0]];

    RegExp.prototype.findall = function (content) {
        var match;
        var result = [];
        while ((match = this.exec(content)) !== null) {
            result.push(match[0]);
        }
        return result;
    };
    RegExp.prototype.split = function (content) {
        var result = [];
        var index = 0;
        while ((match = this.exec(content)) !== null) {
            result.push(content.slice(index, match[2]));
            index = match[2];
        }
        result.push(content.slice(index, content.length));
        return result;
    };

    media.textbox_expander = function (textbox, maximum) {
        /* makes textbox expand/contract to fit current content */
        if (maximum === undefined || maximum === null) {
            maximum = 5;
        }
        var resize = function () {
            var matcher = new RegExp('\r\n|\r|\n', 'gm');
            var content = textbox.val();
            var rows = matcher.findall(content).length + 1;
            rows = Math.min(maximum, rows);
            textbox.attr('rows', rows);
        };
        textbox.change(resize);
        textbox.keyup(resize);
        resize();
    };

    media.SEARCH_TIME = 250; /* ms */
    media.record_search = function (search, all_records, fields) {
        /* attempt to find all records where search is found in given fields */
        if (!search.length) {
            return all_records;
        }
        var matcher = new RegExp(RegExp.escape(search), 'ig');
        return $.map(all_records, function (stat) {
            for (var i = 0; i < fields.length; i++) {
                if (matcher.test('' + stat[fields[i]])) {
                    return {
                        'record': stat,
                        'field': fields[i],
                        'search': search
                    };
                }
            }
            return null;
        });
    };
    media.human_bytes = function (count) {
        var description = '' + Math.round(count) + 'B';
        $.map([['KB', 1000], ['MB', 1000 * 1000], ['GB', 1000 * 1000 * 1000]], function (record) {
            var suffix = record[0], level = record[1];
            if (count > level) {
                description = '' + (Math.round((count / level) * 10) / 10) + suffix;
            }
        });
        return description;
    };
    media.human_bandwidth = function (count, in_bits) {
        if (!in_bits) {
            count *= 8
        }
        var description = '' + Math.round(count) + 'B';
        $.map([['kbps', 1000], ['Mbps', 1000 * 1000], ['Gbps', 1000 * 1000 * 1000]], function (record) {
            var suffix = record[0], level = record[1];
            if (count > level) {
                description = '' + (Math.round((count / level) * 10) / 10) + suffix;
            }
        });
        return description;
    };
    media.human_duration = function (seconds) {
        /* convert duration in seconds to a human description of duration */
        var result = {
            'days': 0, 'hours': 0, 'minutes': 0, 'seconds': 0,
            'getHours': function () { return result.hours; },
            'getMinutes': function () { return result.minutes; },
            'getDays': function () { return result.days; },
            'getSeconds': function () { return result.seconds; },
            'set': function (other) {
                $.map(DAY_SIZES, function (rec) {
                    var key = rec[0].slice(0, rec[0].length - 1);
                    var value = other[key];
                    if (value !== undefined) {
                        result[rec[0]] = value;
                    }
                });
                return result;
            },
            'clone': function () {
                return media.human_duration(media.computer_duration(result));
            },
            'toString': function () {
                return media.human_duration_text(result);
            },
            'toFloat': function () {
                return media.computer_duration(result);
            }
        };
        $.map(DAY_SIZES, function (rec) {
            var prop = rec[0], size = rec[1];
            if (seconds >= size) {
                result[prop] = Math.floor(seconds / (size || 1));
                seconds -= (result[prop] * size);
            }
        });
        return result;
    };
    media.human_duration_text = function (duration, show_seconds) {
        if (typeof duration === 'number') {
            duration = media.human_duration(duration);
        } else if (duration === undefined || duration === null) {
            return "Undefined Duration";
        }
        var result = "";
        $.map(DAY_SIZES, function (record) {
            var value = duration[record[0]];
            var description = "";
            if (record[0] === 'seconds' && !show_seconds) {
                return;
            }
            if (value) {
                if (value === 1) {
                    description = "1 " + record[0].slice(0, record[0].length - 1);
                } else {
                    description = "" + value + ' ' + record[0];
                }
                if (result) {
                    result += ' ';
                }
                result += description;
            }
        });
        return result;
    };
    media.padded = function (v) {
        if (v < 10) {
            return '0' + v;
        } else {
            return '' + v;
        }
    };
    media.short_duration_text = function (duration, show_seconds) {
        if (typeof (duration) === 'number') {
            duration = media.human_duration(duration);
        }
        var base = '' + duration.hours + ':' + media.padded(duration.minutes);
        if (show_seconds) {
            base = base + ':' + media.padded(duration.seconds);
        }
        if (duration.days) {
            return '' + duration.days + 'd ' + base;
        } else {
            return base;
        }
    };
    var DURATION_DAYS = 2, DURATION_HOURS = 4, DURATION_MINUTES = 5, DURATION_SECONDS = 7;
    var ALT_DURATION_VALUE = 1, ALT_DURATION_UNIT = 2;
    media.parse_duration = function (value) {
        /* parse duration text from human input 
        
        ### d ##:##
        ### d ##:##:##
        ##:##
        ##:##:##
        */
        /* Note: in js, the regex object is mutated by calls to exec! */
        var duration_finder = new RegExp("^\\W*(([0-9.]+)\\W*[d])?\\W*((\\d{1,2})[:](\\d{2})([:]([0-9.]+))?)?\\W*$", "gi");
        var alt_duration_finder = /\W*([0-9.]+)\W*([dhms])/gi;
        var duration = {
            days: 0,
            hours: 0,
            minutes: 0,
            seconds: 0
        };
        var found = false;
        var fragments = duration_finder.exec(value);
        if (fragments) {
            if (fragments[DURATION_DAYS]) {
                duration.days = parseFloat(fragments[DURATION_DAYS], 10);
                found = true;
            }
            if (fragments[DURATION_HOURS]) {
                duration.hours = parseFloat(fragments[DURATION_HOURS], 10);
                found = true;
            }
            if (fragments[DURATION_MINUTES]) {
                duration.minutes = parseFloat(fragments[DURATION_MINUTES], 10);
                found = true;
            }
            if (fragments[DURATION_SECONDS]) {
                duration.seconds = parseFloat(fragments[DURATION_SECONDS], 10);
                found = true;
            }
            if (found) {
                return duration;
            } else {
                return null;
            }
        }
        fragments = alt_duration_finder.exec(value);
        if (fragments) {
            while (fragments) {
                var partial = parseFloat(fragments[ALT_DURATION_VALUE]);
                var unit = { 'd': 'days', 'h': 'hours', 'm': 'minutes', 's': 'seconds' }[fragments[ALT_DURATION_UNIT]];
                duration[unit] += partial;
                fragments = alt_duration_finder.exec(value);
            }
            return duration;
        } else {
            return null;
        }
    };
    media.computer_duration = function (struct) {
        var result = 0;
        $.map(DAY_SIZES, function (rec) {
            var prop = rec[0], size = rec[1];
            if (struct[prop]) {
                result += struct[prop] * (size || 1);
            }
        });
        return result;
    };

    media.search_box = function (search_widget, all_records, fields, new_results) {
        /* encapsulate the basic functionality of client-side searching
       
        When user types new values into search widget, search through 
        fields on all_records for matches to the search term, call new_results
        with the results of the query (array of {
            'record': record,
            'field': matching_field
        } objects).
        
        If search is '', then all results are returned
        */
        var _search_timer_handle = null;
        var current_search = null;
        var do_search = function () {
            var value = search_widget.attr('value');
            if (value !== current_search) {
                current_search = value;
                /* send new-results callback */
                new_results(media.record_search(value, all_records, fields));
            }
        };
        var trigger_search = function (evt) {
            /* show the first 100 matches to a given query */
            if (_search_timer_handle) {
                clearTimeout(_search_timer_handle);
                _search_timer_handle = null;
            }
            _search_timer_handle = window.setTimeout(do_search, media.SEARCH_TIME);
        };

        if (search_widget.length) {
            search_widget.keypress(trigger_search);
            search_widget.change(trigger_search);
            search_widget.blur(trigger_search);
        }
        return search_widget;
    };

    media.duration_editor = function (node, initial, change) {
        /* produce a duration editor that calls back change on changes */
        var child_nodes = {
            days: node.find('.days'),
            hours: node.find('.hours'),
            minutes: node.find('.minutes'),
            seconds: node.find('.seconds')
        };
        var struct = media.human_duration(initial || 0);
        $.map(['days', 'hours', 'minutes', 'seconds'], function (field) {
            child_nodes[field].attr('value', struct[field]);
            var update = function () {
                struct[field] = parseFloat(child_nodes[field].attr('value'));
                if (change) {
                    change(media.computer_duration(struct));
                }
            };
            child_nodes[field].change(update);
            child_nodes[field].blur(update);
        });
    };
    media.clickable = function () {
        $('.clickable').each(function () {
            var clickable = $(this);
            var click_url = clickable.attr('data-url');
            if (click_url) {
                clickable.click(function () {
                    window.location = click_url;
                });
            } else {
                clickable.removeClass('clickable');
            }
        });
    };
    media.toggle_controls = function () {
        $('.toggle-link').each(function () {
            var clickable = $(this);
            var click_target = clickable.attr('data-toggle-target');
            if (click_target) {
                click_target = $(click_target);
                if (click_target.length) {
                    clickable.click(function (evt) {
                        click_target.toggle(250);
                        evt.stopPropagation();
                        return false;
                    });
                }
            }
        });
    };
    media.configure_content = function (display) {
        var content = display.data('content_record');
        if (!content) {
            display.find('.title').text('Missing/deleted content');
            return;
        }
        display.attr('data-content-type', content.type);
        display.attr('data-content-id', content.id);
        if (!content) {
            if (console && console.log) {
                console.log('Null content record ' + display);
            }
            return null;
        }
        $(display.find('.title')[0]).html(content.title);
        if (content.subtitle) {
            $(display.find('.subtitle')[0]).html(content.subtitle);
        } else {
            $(display.find('.subtitle')[0]).hide();
        }
        if (content.edit_url) {
            display.find('.edit-link').attr('href', content.edit_url);
        }
        if (content.url) {
            display.find('.preview-link').attr('href', content.url);
        }
        display.find('.preview-src').attr('src', content.url);
        if (content.creation_date) {
            var created = new Date(content.creation_date * 1000);
            display.find('.created').html(created.toString('yyyy-MM-dd hh:mm tt'));
        } else {
            display.find('.created').hide();
        }
        if (content.duration) {
            display.find('.duration-value .duration').text(media.human_duration_text(content.duration));
        } else {
            display.find('.duration-value').hide();
        }
        display.find('.size').text(media.human_bytes(content.size));
        display.find('.filename').text(content.filename);
        if (content.resolution) {
            display.find('.resolution').text(content.resolution);
        } else {
            display.find('.resolution').hide();
        }
        if (content.theme) {
            display.find('.theme-name').text(content.theme.name);
        }
        if (content.channels) {
            display.find('.channel-count').text('' + content.channels.length);
        }
        if (content.content) {
            var subcontent = display.find('.subcontent-section');
            if (subcontent.length) {
                subcontent.empty();
                $.map(content.content, function (sch) {
                    var sub_display = $('.templates .sub-content').clone();
                    sub_display.data('schedule_record', sch);
                    sub_display.data('content_record', sch.content);
                    media.configure_content(sub_display);
                    sub_display.attr('title', media.human_duration_text(sch.duration || sch.content.duration));
                    subcontent.append(sub_display);
                });
            }
        }
        return display;
    };

    media.get_content_template = function (type) {
        /* retrieve content-rendering template for given type */
        return $('.templates .available-content' + '.' + type).clone();
    };
    media.render_content = function (content, no_buttons, on_add, on_default) {
        var display = media.get_content_template(content.type);
        display.data('content_record', content);

        media.configure_content(display);
        var add_button = display.find('.content-add');
        var default_button = display.find('.content-default');
        var delete_button = display.find('.content-delete');
        if (no_buttons) {
            add_button.hide();
            default_button.hide();
            delete_button.hide();
        } else {
            if (add_button.length) {
                if (on_add) {
                    add_button.click(function () {
                        on_add(content);
                    });
                } else {
                    add_button.hide();
                }
            }
            if (default_button.length) {
                if (on_default) {
                    default_button.click(function () {
                        on_default(content);
                    });
                } else {
                    default_button.hide();
                }
            }
            if (delete_button.length && content.delete_url) {
                delete_button.click(function () {
                    window.location = content.delete_url;
                });
            } else {
                delete_button.hide();
            }
        }
        return display;
    };
    media.ts_to_the_hour = function (ts, toadd) {
        /* round given timestamp to previous hour, add toadd (if passed), return result as ts */
        var date;
        if (ts instanceof Date) {
            date = ts;
        } else {
            date = new Date(ts * 1000);
        }
        date.set({ 'minute': 0, 'second': 0, 'millisecond': 0 });
        if (toadd) {
            date.add(toadd);
        }
        return date.getTime() / 1000.0;
    };
    media.date_plus_time = function (date, time) {
        /* given two date objects, take date from first and time from second */
        var new_date = date.clone();
        new_date.set({
            'hour': time.getHours(),
            'minute': time.getMinutes(),
            'second': time.getSeconds()
        });
        return new_date;
    };



    media.content_select = function (choices) {
        var content_select = {};
        content_select.choices = choices;
        content_select.content_map = {};
        content_select.content_key = function (content) {
            return '' + content.type + '_' + content.id;
        };
        $.map(content_select.choices, function (group) {
            $.map(group[1], function (content) {
                content_select.content_map[content_select.content_key(content)] = content;
            });
        });
        content_select.choose_first = function () {
            /* choose the first item and return it */
            for (var key in content_select.content_map) {
                if (content_select.content_map.hasOwnProperty(key)) {
                    return content_select.content_map[key];
                }
            }
        };
        content_select.content_label = function (content) {
            var result = content.title;
            if (content.subtitle) {
                result += ' ' + content.subtitle;
            }
            result = result + ' (#' + content.id + ')';
            if (content.transcoding_available) {
                result += ' [HQ]';
            }
            return result;
        };
        content_select.populate = function (select, include_null) {
            if (include_null) {
                select.append('<option value=""></option>');
            }
            $.map(content_select.choices, function (group) {
                var title = group[0];
                var option_group = $('<optgroup></optgroup>');
                option_group.attr('label', group[0]);
                $.map(group[1], function (content) {
                    var option = $('<option></option>');
                    option.attr('value', content_select.content_key(content));
                    option.text(content_select.content_label(content));
                    if (content.transcoding_available) {
                        option.addClass('transcoding-available');
                    }
                    option_group.append(option);
                });
                select.append(option_group);
            });
        };
        content_select.lookup = function (key) {
            if (key) {
                return content_select.content_map[key];
            } else {
                return null;
            }
        };
        return content_select;
    };
    media.time_editor = function (input, get_current, set_current, show_days) {
        /* Add a time editor to a jquery date editor with trigger button 
        
        input -- text input control to be driven
        get_current() -- function returning current value of the underlying model 
            must return a Date or a human_duration instance 
        set_current( float ) -- function taking duration/offset floating point value 
        show_days -- if true, show a day slider as well as an hour and minute slider...
        
        */
        var editor = $('.templates .time-editor').clone();
        var dialog = editor.find('.time-picker');
        var day_display = dialog.find('.display .day');
        var hour_display = dialog.find('.display .hour');
        var minute_display = dialog.find('.display .minute');

        var update_day_display = function (value) {
            day_display.text("" + value);
        };
        var update_hour_display = function (value) {
            hour_display.text("" + media.padded(value));
        };
        var update_minute_display = function (value) {
            minute_display.text("" + media.padded(value));
        };
        var current_date = get_current();

        var show_dialog = function () {
            var current_date = get_current();
            if (dialog.is(':hidden')) {
                /* configure before display */
                dialog.css({
                    'left': 32,
                    'top': 32
                });
            }
            dialog.bind('clickoutside', function () {
                dialog.hide(500);
            });
            dialog.toggle(500);
            return false;
        };

        dialog.hide();
        /* requires the click outside plugin */
        dialog.bind("clickoutside", function () {
            if (!dialog.is(":hidden")) {
                dialog.hide(500);
            }
        });
        var before_x = input.parent().find('.ui-datepicker-trigger');
        if (!before_x.length) {
            before_x = input;
        }
        editor.insertAfter(before_x);
        editor.find('.time-trigger').click(function (evt) {
            evt.stopPropagation();
            show_dialog();
            return false;
        });

        var hour_slider = dialog.find('.hour-slider').slider({
            'orientation': 'vertical',
            'min': 0,
            'max': 23,
            'value': current_date.getHours(),
            'slide': function (evt, ui) {
                update_hour_display(ui.value);
            },
            'change': function (evt, ui) {
                if (!hour_slider.suppress) {
                    set_current({ 'hour': ui.value });
                }
            },
            'suppress': false
        });
        var minute_slider = dialog.find('.minute-slider').slider({
            'orientation': 'vertical',
            'min': 0,
            'max': 59,
            'value': current_date.getMinutes(),
            'slide': function (evt, ui) {
                update_minute_display(ui.value);
            },
            'change': function (evt, ui) {
                if (!minute_slider.suppress) {
                    set_current({ 'minute': ui.value });
                }
            },
            'suppress': false
        });
        var day_slider = dialog.find('.day-slider');
        if (show_days) {
            dialog.find('.display .days').show();
            day_slider.show();
            day_slider.slider({
                'orientation': 'vertical',
                'min': 0,
                'max': 31,
                'value': 0,
                'slide': function (evt, ui) {
                    update_day_display(ui.value);
                },
                'change': function (evt, ui) {
                    if (!day_slider.suppress) {
                        set_current({ 'day': ui.value });
                    }
                },
                'suppress': false
            });
        } else {
            dialog.find('.display .days').hide();
            day_slider.hide();
        }

        var instance = {
            value: function (value) {
                if (value) {
                    hour_slider.suppress = true;
                    minute_slider.suppress = true;
                    hour_slider.slider('option', 'value', value.getHours());
                    minute_slider.slider('option', 'value', value.getMinutes());
                    update_hour_display(value.getHours());
                    update_minute_display(value.getMinutes());
                    if (show_days) {
                        day_slider.suppress = true;
                        update_day_display(value.getDays());
                        day_slider.slider('option', 'value', value.getDays());
                        day_slider.suppress = false;
                        /* currently can only show days for duration, not date editing */
                        input.attr('value', media.short_duration_text({
                            'hours': value.getHours(),
                            'minutes': value.getMinutes(),
                            'days': value.getDays()
                        }));
                    }
                    hour_slider.suppress = false;
                    minute_slider.suppress = false;
                } else {
                    return get_current();
                }
            }
        };
        instance.value(get_current());
        return instance;
    };


    return media;
})();
window.media = media;
$(document).ready(function () {
    "use strict";
    media.clickable();
    media.toggle_controls();
});
