import React from 'react';

class EditIntentRender extends React.Component {
    render() {
        const { className, as_link, title, handleClick, handleKeyUp, type_name, editing, form, children, icon } = this.props;

        return (
            <div className={className}>
                <a
                    className={(this.props.as_link?'':'flat-button')+' clickable'+(type_name ? '':' iconic')}
                    title={title}
                    onClick={handleClick}
                    onKeyUp={handleKeyUp}>
                    {icon}
                    {(icon && type_name)? ' ':null}
                    {type_name}
                    {children}
                </a>
                {
                    editing &&
                    <div className="edit-intent-form-popup">
                        {form}
                    </div>
                }
            </div>
        );
    }
};

export default EditIntentRender;