import React from 'react';

class CardList extends React.Component {
    static defaultProps = {
        className: '',
        header: null,
        footer: null,
        add_button: null
    };
    render() {
        var self = this;
        return (
            <div className={(self.props.className || '') + ' card-list'}>
                {this.props.header &&
                    <div className="card-list-header">
                        {this.props.header}
                    </div>}
                <div className="card-list-children">
                    {self.props.children}
                    {this.props.add_button &&
                        <div className="add-button-float">
                            {this.props.add_button}
                        </div>}
                </div>
                <div className="card-list-footer">
                    {this.props.footer}
                </div>
            </div>
        );
    }
}

class FloatingActionButton extends React.Component {
    static defaultProps = {
        className: '',
        icon: null,
        hover_label: null
    };
    render() {
        return (
            <div className={'floating-action-button ' + this.props.className}>
                <div>
                    {this.props.icon}
                    {this.props.hover_label && <div className="hover-only">
                        {this.props.hover_label}
                    </div>}
                </div>
            </div>
        );
    }
}


export {
    FloatingActionButton,
    CardList,
};
