import React from 'react';
import { ReactForm } from 'reactform';
import { withStyles } from '@material-ui/core/styles';
import classNames from 'classnames';

const styles = theme => ({
    editTarget: {
        cursor: 'pointer',
        '&:hover': {
            color: 'blue'
        }
    },
});


class BaseClickToEditTarget extends React.Component {
    static defaultProps = {
        'title': null,
        'target': null,
    }
    state = {
        editing: false
    };
    handleClick(evt) {
        this.setState({ editing: true });
        evt.stopPropagation();
    }
    handleDialogClosed(evt) {
        this.setState({ editing: false });
    }
    render() {
        var form = null;
        const { classes } = this.props;
        if (this.state.editing) {
            form = <ReactForm
                key="edit-form"
                target={this.props.target}
                onSave={(evt) => this.handleDialogClosed(evt)}
                onClose={(evt) => this.handleDialogClosed(evt)}
            />;
        }
        return <div title={this.props.title} className={classNames("clickToEdit", "clickable", classes.editTarget)} onClick={(evt) => this.handleClick(evt)}>
            {this.props.children}
            {form}
        </div>;
    }
}
const ClickToEditTarget = withStyles(styles)(BaseClickToEditTarget);

export default ClickToEditTarget;
export { ClickToEditTarget };