import { log_render_errors } from 'debugfail';
import { fa_icon } from 'faicon';
import React from 'react';

class ContentTypeIcon extends React.Component {
    static displayName = 'ContentTypeIcon';

    render() {
        var type_name = this.props.content.type;
        var className = '';
        if (type_name === 'movie') {
            className = 'film';
        } else if (type_name === 'presentation') {
            className = 'bar-chart';
        } else if (type_name === 'playlist') {
            className = 'list';
        } else if (type_name === 'image') {
            if (this.props.content.is_advertisement) {
                className = "shopping-cart";
            } else {
                className = "picture-o";
            }
        } else if (type_name === 'hls') {
            className = "desktop";
        } else if (type_name === 'multicast') {
            if (this.props.content.multicast) {
                className = "cloud";
            } else {
                className = "desktop";
            }
        } else if (type_name === 'epg') {
            className = 'table';
        } else if (type_name == 'capture') {
            className = 'video-camera';
        } else if (type_name == 'qam') {
            className = 'television';
        } else if (type_name === undefined || type_name === 'default' || type_name === null) {
            className = 'exclamation';
        } else if (type_name == 'waiting') {
            className = 'clock-o';
        } else if (type_name == 'disabled') {
            className = 'ban';
        } else if (type_name == 'failover') {
            className = 'retweet';
        } else if ((!this.props.content) || type_name === undefined || type_name === null || type_name === 'default') {
            className = 'stop';
        } else {
            className = 'question-circle';
        }
        if (className) {
            type_name = this.props.content.type_name || this.props.content.type || 'Unregistered Type';
            return (
                <span className={'content-type-icon media-type ' + (this.props.className || '')}>
                    {fa_icon(className, this.props.title || ("Media-type icon for " + type_name))}
                </span>
            );
        } else {
            return null;
        }
    }
}

export {
    ContentTypeIcon,
};
