import {log_render_errors} from 'debugfail';
import $ from 'fakequery';
import React from 'react';


class MessageList extends React.Component {
    static displayName = 'MessageList';

    render() {
        var self = this;
        return (
            <ul
                className={'message-list compact-list no-bullets '+(self.props.className||'')}>
                {$.map( self.props.messages, function( msg,i ) {
                    return (
                        <li className="message" key={i}>
                            {''+msg}
                        </li>
                    );
                })}
            </ul>
        );
    }
}

var MessageListFactory = React.createFactory( MessageList );


class ErrorList extends React.Component {
    static displayName = 'ErrorList';

    render() {
        return MessageListFactory({
            className:'error-list',
            messages: this.props.errors
        });
    }
}

var ErrorListFactory = React.createFactory( ErrorList );

export {
    ErrorList,
    ErrorListFactory,
    MessageList,
    MessageListFactory
};
