import $ from "fakequery";

var FieldSorter = function( state ) {
    var sorter = $.extend( {'fields':[]}, state || {});
    $.extend( sorter, {
        compare_field: function( a,b,field ) {
            /* Produce raw comparison of field in a and b */
            /* Sort null and undefined first */
            if (a[field] === undefined || a[field] === null) {
                if (b[field] === undefined || b[field] === null) {
                    return 0;
                }
                return -1;
            } else if (b[field] === undefined || b[field] === null) {
                return 1;
            }
            /* Now just regular comparisons */
            /* TODO: could add better textual sorting */
            if (a[field] < b[field]) {
                return -1;
            } else if (a[field] > b[field]) {
                return 1;
            } else {
                return 0;
            }
        },
        compare_function: function( sort_by ) {
            var sort_function = function(a,b) {
                var field_index = 0;
                for (field_index=0;field_index<sort_by.length;field_index++) {
                    var raw = sorter.compare_field( a,b, sort_by[field_index][0] );
                    if (raw !== 0) {
                        return raw * sort_by[field_index][1];
                    }
                }
            };
            return sort_function;
        },
        sort: function( records ) {
            var local = records.slice(0);
            local.sort( sorter.compare_function( sorter.fields ) );
            return local;
        },
        toggle: function( field ) {
            /* toggle a given field on header-click */
            var previous = $.grep( sorter.fields, function(rec) {
                return rec[0] === field;
            });
            var rest = $.grep( sorter.fields, function(rec) {
                return rec[0] !== field;
            });
            if (previous.length) {
                rest.unshift( [field,previous[0][1]*-1] );
            } else {
                rest.unshift( [field,1] );
            }
            sorter.fields = rest;
            return rest;
        },
        sort_direction: function( field ) {
            /* Generate css-compatible group for ascending/descending display */
            var current = $.grep( sorter.fields, function(rec) { return rec[0] === field; } );
            if (current.length) {
                var direction = current[0][1];
                if (direction === 1) {
                    return 'ascending';
                } else {
                    return 'descending';
                }
            }
            return '';
        }
    });
    return sorter;
};

export default FieldSorter;