/* Provide "nearest form-set" resolution for low-level components */
import React from 'react';
const FormContext = React.createContext();
import stores from "storeregistry";
import getDisplayName from 'react-display-name';
import {FormStorage} from 'storages/basestorage';

function using_nearest_form(Component) {
    return React.forwardRef((props, ref) => {
        if (props.storage) {
            var storage = props.storage;
            if (typeof storage == 'string') {
                storage=stores[storage];
            }
            if (storage.get_form_template || storage.get_form) {
                /* Only use *form* storages if passed in */
                return <Component ref={ref} {...props} storage={storage} />;
            }
        }
        return <FormContext.Consumer {...props}>
            {(storage) => {
                if (storage) {
                    return <Component  {...props} storage={storage} ref={ref} />;
                } else {
                    return <div className="error missing-form-storage">
                        Missing form storage context for this component {getDisplayName(Component) || Component}
                        <Component {...props} ref={ref} />
                    </div>;
                }
            }}
        </FormContext.Consumer>;
    });
}
function providing_nearest_form(Component, storage_key) {
    if (!Component) {
        console.error("Got a null component for key "+storage_key);
        throw( "Null component");
    }
    if (!storage_key) {
        console.error("Passed a null key for providing_nearest_form");
        throw("Null storage key");
    }
    class WithNearestForm extends React.Component {
        static displayName = `fp_${storage_key}_${getDisplayName(Component)}`;
        render() {
            if (!stores[storage_key]) {
                try {
                    stores[storage_key] = FormStorage({
                        key: storage_key,
                        debug: false,
                    });
                } catch (e) {
                    console.log(`providing_nearest_form() referencing an undefined storage: ${storage_key} for ${Component} did you register it in reactforms ${e}`);
                    return <div className="error">
                        Missing form storage {storage_key}
                    </div>;
                }
            }
            if (!stores[storage_key].get_form) {
                console.warn(`The storage key ${storage_key} references a non-form storage (no get_form method); check your providing_nearest_form() call`);
                return <div className="error">
                    Non-form storage {storage_key} encountered in form-storage requiring element
                </div>;
            }
            return <FormContext.Provider value={stores[storage_key]}>
                <Component {...this.props} />
            </FormContext.Provider>;
        }
    }
    return WithNearestForm;
}

export {FormContext,using_nearest_form,providing_nearest_form};
