import $ from 'fakequery';
import React from 'react';
import { stores } from 'storeregistry';
import { BaseStorage } from "storages/basestorage";
import { shallow_compare } from "signals";

function default_system_lockouts(props) {
    if (!stores.system_lockouts) {
        BaseStorage({
            debug: false,
            period: 5,
            key: 'system_lockouts',
            refresh_on_post: true
        }).poll();
    }
    return stores.system_lockouts;
}

const have_lockout = (key) => {
    const lockouts = default_system_lockouts();
    return (
        lockouts
        && lockouts.lockouts
        && lockouts.lockouts.individual
        && lockouts.lockouts.individual[key]
    );
};

const WithLockouts = (Component) => {
    class WithLockouts extends React.Component {
        static defaultProps = {
            Component: Component,
        }
        state = {
            'lockouts': null,
        }
        componentDidMount() {
            this.mounted = true;
            default_system_lockouts().change.listen(this.on_lockout_change);
        }
        componentWillUnmount() {
            this.mounted = false;
            default_system_lockouts().change.ignore(this.on_lockout_change);
        }
        on_lockout_change = (update) => {
            const { lockouts } = update;
            if (this.mounted) {
                if (
                    (!this.state.lockouts) ||
                    (!shallow_compare(this.state.lockouts, lockouts))
                ) {
                    console.log(`Re-render for lockouts`);
                    this.setState({ lockouts });
                }

            }
        }
        render() {
            const { Component, ...childProps } = this.props;
            if (Component) {
                return <Component lockouts={default_system_lockouts().lockouts} {...childProps} />;
            } else {
                return 'Missing Component';
            }
        }

    }
    return WithLockouts;
}


class BaseLockoutsView extends React.Component {
    static defaultProps = {
        lockouts: null,
    };
    render() {
        var current = this.props.lockouts;
        var view;
        if (current && current.messages) {
            if (current.messages.length > 0) {
                var children = $.map(current.messages, function (message, i) {
                    return (
                        <li className="reason" key={i}>
                            {message}
                        </li>
                    );
                });
                view = <div className="messages lockout-warning">
                    <span>
                        System Locked, some operations disabled for the following reasons:
                    </span>
                    <ul className="no-bullets">
                        {children}
                    </ul>
                </div>;
            } else {
                view = null;
            }
        } else {
            view = null;
        }
        return view;
    }
}
const LockoutsView = WithLockouts(BaseLockoutsView);

export {
    LockoutsView,
    WithLockouts,
    have_lockout,
}
