import { fa_icon } from 'faicon';
import { log_render_errors } from 'debugfail';
import { DEFAULT_LOCALSTORAGE } from 'storages/localstoragebacking';
import React from 'react';

var detailStateFunction = function (key) {
    /* Construct a state getter/setting for the given storage key */
    var detailState = function (value) {
        if (value !== undefined) {
            DEFAULT_LOCALSTORAGE().set(key, value);
        } else {
            value = DEFAULT_LOCALSTORAGE().getItem(key);
        }
        return value;
    };
    return detailState;
};

var DetailStateRefresh = function (component, detailState) {
    /* wraps component with a trivial component that just sets state when the detailState changes */
    class DetailStateRefresh extends React.Component {
        static displayName = 'DetailStateRefresh';

        static defaultProps = {
            'detailState': detailState
        };

        componentWillMount() {
            var self = this;
            DEFAULT_LOCALSTORAGE().change.listen(function () {
                self.setState({});
            });
        }

        render() {
            /* TODO: should allow factory *or* class reference */
            //this.props.detailState = detailState;
            return component(this.props, this.children);
        }
    }

    return React.createFactory(DetailStateRefresh);
};

class StatefulMixin extends React.Component {
    static defaultProps = {
        'detailState': null
    };
    componentDidMount() {
        var self = this;
        this.wanted = true;
        DEFAULT_LOCALSTORAGE().change.listen(function () {
            if (!self.wanted) {
                return;
            }
            self.setState({});
        });
    }
    componentWillUnmount() {
        this.wanted = false;
    }
    toggleDetailState() {
        var current = this.props.detailState();
        this.props.detailState(!current);
        this.setState({});
        return current;
    }
}

/** applies an exanded/collapsed className around its div

Use expanded-only and collapsed-only tags to then hide/show children...
*/
class StatefulDropDown extends StatefulMixin {
    static defaultProps = {
        className: ''
    };
    render() {
        var self = this;
        var expanded = self.props.detailState();
        return <div
            className={self.props.className + ' stateful-drop-down ' + (expanded ? 'expanded' : 'collapsed')}>
            {self.props.children}
        </div>;
    }
};
var StatefulDropDownFactory = React.createFactory(StatefulDropDown);

class StatefulIndicator extends StatefulMixin {
    render() {
        var self = this;
        var expanded = self.props.detailState();
        return fa_icon(
            (expanded ? 'angle-up' : 'angle-down') + ' trigger-button'
        );
    }
}
var StatefulIndicatorFactory = React.createFactory(StatefulIndicator);

class StatefulTrigger extends StatefulMixin {
    static defaultProps = {
        'label': null,
        'className': null,
        'hide_help': 'Click to hide details',
        'show_help': 'Click to show details'
    };
    render() {
        var self = this;
        var expanded = self.props.detailState();
        return (
            <div
                className={'clickable stateful-trigger ' + (expanded ? 'expanded ' : 'collapsed ') + (this.props.className || '')}
                title={expanded ? self.props.hide_help : self.props.show_help}
                onClick={self.toggleDetailState.bind(self)}>
                {this.props.children}
            </div>
        );
    }
};
var StatefulTriggerFactory = React.createFactory(StatefulTrigger);

export {
    detailStateFunction,
    StatefulTriggerFactory,
    StatefulTrigger,
    StatefulIndicatorFactory,
    StatefulIndicator,
    StatefulDropDownFactory,
    StatefulDropDown,
    DetailStateRefresh,
    StatefulMixin,
};
