import $ from 'fakequery';
import {BaseStorage} from "storages/basestorage";

var ContentStorage = function( state ) {
    var storage = BaseStorage( {
        'key':'media_content_choices',
        'choices': [],
        'refresh_on_post': true,
        'id_map': {}
    });
    $.extend( storage, state || {});
    $.extend( storage, {
        content_key: function( content ) {
            return content.type+'.'+content.id;
        },
        content_for_key: function( key ) {
            var content = {'type':'default','title':'No Content'};
            $.map( storage.choices, function( group ) {
                $.map( group[1], function( c ) {
                    if (storage.content_key(c) == key) {
                        content = c;
                    }
                });
            });
            return content;
        },
        content_for_url: function( url ) {
            var content = {'type':'default','title':'No Content'};
            $.map( storage.choices, function( group ) {
                $.map( group[1], function( c ) {
                    if (c.edit_url == url) {
                        content = c;
                    }
                });
            });
            return content;
        },
        ensure_keys: function() {
            $.map( storage.choices, function(choice) {
                choice.__key__ = choice.id;
            });
        }
        
    });
    return storage;
};
export {ContentStorage};
