/* Generic tree layout formatter */
import {log_render_errors} from 'debugfail';
import React from 'react';

class TreeLayout extends React.Component {
    static displayName = 'TreeLayout';

    static defaultProps = {
        details_width: 6, // over 24, so 1/4 by default...
        node_header: null,
        details: null,
        children_header: null,
        className: null
    };

    render() {
        return (
            <div className={'tree-node pure-g '+this.props.className}>
                {this.props.node_header?<div className="pure-u-1 node-header">
                    {this.props.node_header}
                </div>:null}
                <div
                    className={'pure-u-1 pure-u-md-'+this.props.details_width+'-24 object-description-column'}>
                    <div className="object-description">
                        {this.props.details}
                    </div>
                </div>
                <div
                    className={'pure-u-1 pure-u-md-'+(24-this.props.details_width)+'-24 object-children-column'}>
                    <div className="object-children">
                        <div className="children-header">
                            {this.props.children_header}
                        </div>
                        <div className="children">
                            {this.props.children}
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}

var TreeLayoutFactory = React.createFactory( TreeLayout );

export {
    TreeLayout,
    TreeLayoutFactory
};
