/* Wrapper that re-renders children on signal changes

<UpdateOnSignal signals={[storage1.change,storage2.change]}>
    <MyCoolTable  />
</UpdateOnSignal>
*/
import React from 'react';
import PropTypes from 'prop-types';

export default class UpdateOnSignal extends React.Component {
    static defaultProps = {
        'Component': null,
        'signals': []
    };
    mounted=true;
    componentDidMount() {
        this.props.signals.map((signal) => {
            signal.listen(this.onChange);
        });
    }
    componentWillUnmount() {
        this.mounted=false;
        this.props.signals.map((signal) => {
            signal.ignore(this.onChange);
        });
    }
    onChange = () => {
        if (this.mounted) {
            this.setState({});
        }
    }
    render() {
        // console.info(`Re-render the UpdateOnSignal`);
        const {signals,Component,...childProps} = this.props;
        return <Component {...childProps} />;
    }
}
const SignalType = PropTypes.shape({
    'listen': PropTypes.func.isRequired,
    'ignore': PropTypes.func.isRequired,
});

UpdateOnSignal.propTypes = {
    'signals': PropTypes.arrayOf(SignalType).isRequired,
};