;
(function ( $, window, document, undefined ) {
    $.status_poller = function( display, callback, period ) {
        var self = { 
            statusCode: {
                400: 'Bad Request',
                401: 'Unauthorized (Session Timeout)',
                402: 'Payment Required',
                403: 'Forbidden',
                404: 'Not Found (Status Not Available)',
                405: 'Method Not Allowed',
                406: 'Content Type Not Available',
                407: 'Proxy Authentication Failed',
                408: 'Timeout',
                409: 'Conflict Failure',
                410: 'Resource Gone',
                411: 'Length Required',
                412: 'Precondition Not Met',
                500: 'Internal Server Error (Unable to Complete Update)',
                501: 'Not Implemented',
                502: 'Bad Gateway (Internal Server Offline)',
                503: 'Service Unavailable',
                504: 'Gateway Timeout (Internal Server Running Too Slow)'
            }
        };
        self.refresh = function() {
            /* start the refresh cycle for this poller */
            if (! self.active ) {
                self.active = true;
                display.addClass( 'loading' );
                display.removeClass( 'loading-error' );
                var status_handler = function( description ) {
                    var handler = function( xhr, textStatus ) {
                        callback( {
                            'error':true,
                            'messages':[description]
                        });
                    };
                };
                $.ajax({
                    url: display.attr( 'data-url' ),
                    dataType: 'json',
                    cache: false,
                    success: function( data ) {
                        self.active = false;
                        display.removeClass('loading');
                        if (data.error) {
                            display.addClass('loading-error');
                            callback(data);
                        } else {
                            callback( data );
                        }
                    },
                    error: function( xhr, textStatus ) {
                        self.active = false;
                        display.removeClass( 'loading' );
                        display.addClass( 'loading-error' );
                        if (xhr.readyState === 0) {
                            textStatus = 'Connection Failure';
                        } else if (xhr.readyState === 4) {
                            if (xhr.responseText && xhr.responseText[0] != '<') {
                                textStatus = xhr.responseText;
                            } else if (self.statusCode[xhr.status] !== undefined) {
                                textStatus = self.statusCode[xhr.status];
                            } else {
                                textStatus = xhr.statusText;
                            }
                        } else {
                            textStatus = 'Error loading data';
                        }
                        callback( {
                            'error':true,
                            'messages':[textStatus]
                        });
                    }
                });
            }
        };
        self.timer = $.timer( period || 5000, self.refresh );
        self.timer.start();
        return self;
    };
})( jQuery, window, document );
