/* Common system view functionality */
$(document).ready( function() {
    "use strict";
    var now_seconds = function() {
        var now = new Date();
        return Math.round( now.getTime() / 1000 );
    };
    var shutdown_dialog = function() {
        var shutdown_url = $('.power-form').attr( 'data-time-url' );
        var reboot_dialog = function( msg, expected ) {
            var dialog = $('<div class="shutdown-dialog"></div>');
            var _poll_timer_handle = null;
            dialog.append( $('<div class="shutdown-message"></div>' ));
            var update = function() {
                var delta = expected-now_seconds();
                var message = '';
                if (delta < -10) {
                    window.clearInterval(_poll_timer_handle);
                    dialog.dialog( 'close' );
                    shutdown_dialog();
                } else if (delta < 0){
                    message = 'Server should be shut down';
                } else {
                    message = msg.replace( '...', ''+delta );
                }
                dialog.find( '.shutdown-message' ).text( message );
            };
            dialog.dialog( {
                resizable: false,
                height: 180,
                width: 350,
                modal: true,
                title: 'Pending System Shutdown',
                buttons: {
                    'OK': function() {
                        window.clearInterval(_poll_timer_handle);
                        dialog.dialog( 'close' );
                    },
                    'Cancel System Shutdown': function() {
                        window.clearInterval(_poll_timer_handle);
                        dialog.dialog( 'close' );
                        $('button[name=shutdown_cancel]').click();
                    }
                }
            });
            update();
            _poll_timer_handle = window.setInterval( update, 1000 );
        };
        $.ajax({
            url: shutdown_url,
            type: 'GET',
            dataType: 'text',
            cache: false,
            success: function( data ) {
                var expected = Math.round( parseFloat( data ) );
                if (expected > now_seconds()) {
                    reboot_dialog( 'System will shut down in ... seconds', expected );
                }
            }, error: function( jqXHR ) {
                if (jqXHR.status === 404) {
                    console.log( 'No current shutdown scheduled' );
                }
            }, statusCode: {
                404: function() {
                    console.log( 'No current shutdown scheduled' );
                }
            }
        });
    };
    var dhcp_dependencies = function() {
        $.map( ['eth0','eth1'], function( iface ) {
            var field_prefix = '#id_'+iface+'-';
            $( field_prefix+ 'dhcp' ).each( function() {
                var checkbox = $(this);
                var dependent_fields = [ 'ip_address','netmask','gateway','dns_server1','dns_search'];
                var disable = function() {
                    $.map( dependent_fields, function( field ) {
                        $(field_prefix+field).attr('disabled','disabled');
                    });
                };
                var enable = function() {
                    $.map( dependent_fields, function( field ) {
                        $(field_prefix+field).attr('disabled',null);
                    });
                };
                var on_check = function() {
                    if (checkbox.is( ':checked' )) {
                        disable();
                    } else {
                        enable();
                    }
                };
                checkbox.change( on_check );
                on_check();
            });
        });
    };
    var periodic_reboot_dependencies = function() {
        var periodic_reboot = $('#id_periodic_reboot');
        var dependent = $('#id_periodic_reboot_time' );
        var on_change = function() {
            if (parseFloat(periodic_reboot.val()) === 0) {
                dependent.prop('disabled',true);
            } else {
                dependent.prop('disabled',null);
            }
        };
        periodic_reboot.change( on_change );
        on_change();
    };
    dhcp_dependencies();
    periodic_reboot_dependencies();
    shutdown_dialog();
});
