;
(function ( $, window, document, undefined ) {
    $.timer = function( interval, target ) {
        var timer = {
            interval: interval,
            target: target,
            handle: null
        };
        timer.start = function() {
            if (! timer.handle) {
                timer.target();
                timer.handle = window.setInterval( timer.target, timer.interval );
            }
            return timer;
        };
        timer.stop = function() {
            if (timer.handle) {
                window.clearInterval( timer.handle );
            }
            timer.handle = null;
            return timer;
        };
        return timer;
    };
})( jQuery, window, document );
