/* Subscription provider for components that need access to current user */
import React from 'react';
import { USER_RESOLVED } from 'storages/ajaxobservables';
import PropTypes from 'prop-types';

const CURRENT_USER = [];

class BaseWithCurrentUser extends React.Component {
    /* HOC Component that watches for current user changes and passes current in as prop `user`

    export default WithCurrentUser(BaseComponent);
    */
    static defaultProps = {
        user: null,
        Component: null,
    };
    state = {
        user: (CURRENT_USER.length && CURRENT_USER[0]) || {
            'permissions': [],
            'groups': [],
            'is_superuser': false,
            'is_staff': false,
            'is_anonymous': true,
            'name': '',
            has_permission: () => false,
        },
    }
    current_user = () => {
        return this.props.user||this.state.user;
    }
    on_user_resolved = (user) => {
        // console.info(`User record: ${JSON.stringify(user)}`);
        CURRENT_USER[0] = user;
        if (this.mounted) {
            this.setState({ user: user});
        }
    }
    componentDidMount() {
        this.mounted=true;
        USER_RESOLVED.listen(this.on_user_resolved);
    }
    componentWillUnmount() {
        USER_RESOLVED.ignore(this.on_user_resolved);
        this.mounted = false;
    }
    render() {
        const {Component,...childProps} = this.props;
        // Note: current_user is *overriding* this.props.user if present...
        return <Component
            {...childProps}
            user={this.current_user()}
        />;
    }
}
const UserRecordPropType = PropTypes.shape({
    'permissions': PropTypes.arrayOf(PropTypes.string).isRequired,
    'groups': PropTypes.arrayOf(PropTypes.shape({
        'id': PropTypes.number,
        'name': PropTypes.string, 
        'type': PropTypes.string,
    })).isRequired,
    'is_superuser': PropTypes.bool.isRequired,
    'is_anonymous': PropTypes.bool.isRequired,
    'name': PropTypes.string.isRequired,
    'has_permission': PropTypes.func.isRequired,
});
BaseWithCurrentUser.propTypes = {
    user: UserRecordPropType,
};
const WithCurrentUser = (Component) => {
    return (props) => {
        return <BaseWithCurrentUser
            {...props}
            Component={Component}
        />;
    };
};

export default WithCurrentUser;
export {WithCurrentUser,BaseWithCurrentUser,UserRecordPropType};
