"""Provides support-download process which generates tarfile download"""
from atxstyle import defaultsettings
settings = defaultsettings.setup_default()
from fussy import nbio,twrite
import glob, os

CORE_FILES = [
    '/etc/atxlicense',
    '/etc/nginx',
    '/etc/fussy',
    '/etc/firmware/',
    '/etc/firmware/release.conf',
    '/etc/network',
    '/etc/lsb-release',
    '/etc/%s'%(settings.PRODUCT,),
    
    '/opt/firmware/current/etc/*/release.conf',
    '/opt/firmware/current/arcos/Arcos3ScreensApp/versative-install.txt',
    
    '/dev/shm/vproxy',
    '/dev/shm/status',
    
    '/var/firmware/system-summary.txt',
    '/var/firmware/backup.sql',
    '/var/firmware/run',
    '/var/firmware/log',
    '/var/firmware/arcos',
    '/var/firmware/protected',
    '/var/firmware/media',
    
    '/var/log/syslog',
    '/var/log/nginx',
    '/var/log/supervisor',
    '/var/log/auth',
    '/var/log/kern.log',
    '/var/log/udev',
    '/var/log/fail2ban.log',
    '/var/log/dmesg',
    '/var/log/boot.log',
    '/var/log/dpkg.log',
] + getattr( settings, 'SUPPORT_DOWNLOAD_EXTRA',[])
EXCLUDES = [
    '*.strace',
    'core*',
    'tarlogs*.bz2',
    'tarlogs*.gz',
    'detect-cache',
    '/var/firmware/media/ringbuffer',
    '/var/firmware/media/theme-up',
    '/var/firmware/run/trap.status',
    '/var/firmware/firmware',
    '/var/firmware/protected/uploads',
    '*.rbf',
    'atxip2a-peripheral*.tar.gz',
    '/etc/atxlicense/keys',
    '/etc/nginx/keys',
    '/var/log/*.gz',
    'django-secret.conf',
]  + getattr( settings, 'SUPPORT_DOWNLOAD_EXTRA_EXCLUDES',[])
TAR = '/bin/tar'

def main(globs=CORE_FILES,excludes=EXCLUDES):
    """To be called by the product-specific support-download script"""
    os.chdir( '/' )
    dump_command = '/usr/bin/pg_dump -T auth_user %s > /var/firmware/backup.sql'
    if os.getuid() == 0:
        dump_command = 'sudo -u postgres '+dump_command
    if hasattr( settings, 'DATABASES' ):
        nbio.Process(
            # TODO: could use the password too...
            dump_command%(
                settings.DATABASES['default']['NAME'],
            )
        )()
    sections = []
    for process in [
        'ls -la /opt/',
        'ls -la /opt/firmware/',
        'sensors',
        'ifconfig -a',
        
        'ip route show',
        'ip link show',
        'ip addr show',
        'ip mroute show',
        'ip netconf show',
        
        'netstat -g',
        'netstat -s',
        'tc -s qdisc show',
        'cat /proc/net/bonding/*',
        'ls -la /dev/atx*',
        'ls -la /dev/shm/',
        'cat /opt/atx/ip2a/cvp/ip2a-cvp-info.xml',
        'lspci -v |grep -i altera',
        '~/Arcos3ScreensApp/AnalogUtility/AnalogUtility -status',
        'ps auxf',
        'free -m',
        'uptime',
        'uname -a',
        'lsmod',
        'dpkg -l',
        'cat /proc/cpuinfo',
        'mount',
        'ipmitool lan print 1',
        'ipmitool sensor',
    ]:
        try:
            content = nbio.Process(
                process, 
                shell=True
            )()
        except nbio.ProcessError:
            content = 'Failure running query'
        sections.append( (process,content))
    formatted = []
    for (command,content) in sections:
        formatted.append('-'*80)
        formatted.append('$ '+command.strip())
        formatted.append(content.strip())
    twrite.twrite( '/var/firmware/system-summary.txt','\n'.join( formatted ))
    os.execvp(
        TAR,
        [TAR] + 
        ['--exclude=%s'%e
            for e in EXCLUDES
        ] + 
        [
            g for g in globs
            if glob.glob(g)
        ] + 
        ['-zcf','-']
    )

if __name__ == "__main__":
    main()

